/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.right.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.group.InvalidModificationException;
import org.ametys.core.right.Profile;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class ProfileDAO
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = ProfileDAO.class.getName();
    protected ServiceManager _smanager;
    protected CurrentUserProvider _currentUserProvider;
    protected RightProfilesDAO _profilesDAO;

    public void service(ServiceManager smanager) throws ServiceException {
        this._smanager = smanager;
        this._profilesDAO = (RightProfilesDAO)smanager.lookup(RightProfilesDAO.ROLE);
    }

    @Callable(rights={"*"})
    public Map<String, Object> getProfile(String id) throws ServiceException, InvalidModificationException {
        return this.getProfile(id, false);
    }

    @Callable(rights={"Runtime_Rights_Rights_Profile_See", "Runtime_Rights_Rights_Profile_Handle"})
    public Map<String, Object> getProfile(String id, boolean withRights) throws ServiceException, InvalidModificationException {
        Profile profile = this._profilesDAO.getProfile(id);
        if (profile == null) {
            return null;
        }
        Map<String, Object> jsonProfile = profile.toJSON();
        if (withRights) {
            jsonProfile.put("rights", this._profilesDAO.getRights(profile));
        }
        return jsonProfile;
    }

    @Callable(rights={"Runtime_Rights_Rights_Profile_Handle"})
    public Map<String, Object> addProfile(String name, String context) throws ServiceException, InvalidModificationException {
        this.getLogger().debug("Starting profile creation");
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("The profile name cannot be empty");
        }
        this.getLogger().info("User {} is adding a new profile '{}'", (Object)this._getCurrentUser(), (Object)name);
        Profile profile = this._profilesDAO.addProfile(name, context);
        this.getLogger().debug("Ending profile creation");
        return profile.toJSON();
    }

    @Callable(rights={"Runtime_Rights_Rights_Profile_Handle"})
    public Map<String, Object> renameProfile(String id, String name) throws ServiceException, InvalidModificationException {
        this.getLogger().debug("Starting profile modification");
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("The profile new name cannot be empty");
        }
        this.getLogger().info("User {} is renaming the profile '{}' to '{}'", new Object[]{this._getCurrentUser(), id, name});
        Profile profile = this._profilesDAO.getProfile(id);
        if (profile == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "unknown-profile");
            return result;
        }
        this._profilesDAO.renameProfile(profile, name);
        this.getLogger().debug("Ending profile modification");
        return profile.toJSON();
    }

    @Callable(rights={"Runtime_Rights_Rights_Profile_Handle"})
    public Map<String, Object> editProfileRights(String id, List<String> rights) throws ServiceException, InvalidModificationException {
        this.getLogger().debug("Starting profile modification");
        this.getLogger().info("User {} is edit rights of profile '{}'", (Object)this._getCurrentUser(), (Object)id);
        Profile profile = this._profilesDAO.getProfile(id);
        if (profile == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "unknown-profile");
            return result;
        }
        this._profilesDAO.updateRights(profile, rights);
        this.getLogger().debug("Ending profile modification");
        return profile.toJSON();
    }

    @Callable(rights={"Runtime_Rights_Rights_Profile_Handle"})
    public Map<String, Object> deleteProfiles(List<String> ids) throws InvalidModificationException, ServiceException {
        this.getLogger().debug("Starting profile removal");
        HashMap<String, Object> results = new HashMap<String, Object>();
        ArrayList<String> deletedProfiles = new ArrayList<String>();
        ArrayList<String> undeletedProfiles = new ArrayList<String>();
        for (String id : ids) {
            if (!"READER".equals(id)) {
                this.getLogger().info("User {} is is removing profile '{}'", (Object)this._getCurrentUser(), (Object)id);
                Profile profile = this._profilesDAO.getProfile(id);
                if (profile != null) {
                    this._profilesDAO.deleteProfile(profile);
                    deletedProfiles.add(id);
                    continue;
                }
                this.getLogger().info("User {} is trying to remove an unexisting profile '{}'", (Object)this._getCurrentUser(), (Object)id);
                undeletedProfiles.add(id);
                continue;
            }
            this.getLogger().error("You cannot remove the system profile 'READER'");
            undeletedProfiles.add(id);
        }
        results.put("undeletedProfiles", undeletedProfiles);
        results.put("deletedProfiles", deletedProfiles);
        this.getLogger().debug("Ending profile removal");
        return results;
    }

    public Map<String, List<Map<String, Object>>> getProfiles2Json(String[] ids) {
        ArrayList<HashMap<String, Object>> profiles = new ArrayList<HashMap<String, Object>>();
        for (String id : ids) {
            this.getLogger().info("User {} is exporting profile '{}'", (Object)this._getCurrentUser(), (Object)id);
            Profile profile = this._profilesDAO.getProfile(id);
            if (profile != null) {
                HashMap<String, Object> profile2json = new HashMap<String, Object>(profile.toJSON());
                List<String> rights = this._profilesDAO.getRights(profile);
                profile2json.put("rights", rights);
                profiles.add(profile2json);
                continue;
            }
            this.getLogger().info("User {} is trying to export an unexisting profile '{}'", (Object)this._getCurrentUser(), (Object)id);
        }
        return Map.of("profiles", profiles);
    }

    protected UserIdentity _getCurrentUser() {
        if (this._currentUserProvider == null) {
            try {
                this._currentUserProvider = (CurrentUserProvider)this._smanager.lookup(CurrentUserProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new IllegalStateException(e);
            }
        }
        return this._currentUserProvider.getUser();
    }
}

