/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.right.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.right.Profile;
import org.ametys.core.right.RightProfilesDAO;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class ProfileSearchAction
extends ServiceableAction {
    private RightProfilesDAO _profilesDAO;

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        String includeReader;
        if (this._profilesDAO == null) {
            this._profilesDAO = (RightProfilesDAO)this.manager.lookup(RightProfilesDAO.ROLE);
        }
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap result = new HashMap();
        ArrayList<Map<String, Object>> profilesAsJSON = new ArrayList<Map<String, Object>>();
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        profiles.addAll(this._profilesDAO.getProfiles(null));
        String optionalContext = request.getParameter("context");
        if (StringUtils.isNotBlank((CharSequence)optionalContext)) {
            profiles.addAll(this._profilesDAO.getProfiles(optionalContext));
        }
        if (!Boolean.parseBoolean(includeReader = Objects.toString(request.getParameter("includeReader"), "true"))) {
            Profile readerProfile = this._profilesDAO.getProfile("READER");
            profiles.remove(readerProfile);
        }
        for (Profile profile : profiles) {
            Map<String, Object> profile2json = profile.toJSON();
            profile2json.put("rights", this._profilesDAO.getRights(profile));
            profilesAsJSON.add(profile2json);
        }
        result.put("profiles", profilesAsJSON);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
}

