/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupDirectoryContextHelper;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.user.User;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.core.group.GroupHelper;
import org.ametys.plugins.core.user.UserHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class UserAndGroupSearchManager
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = UserAndGroupSearchManager.class.getName();
    private static final int _DEFAULT_OFFSET_VALUE = 0;
    private static final int _DEFAULT_COUNT_VALUE = 20;
    private UserManager _userManager;
    private UserHelper _userHelper;
    private GroupDirectoryDAO _groupDirectoryDAO;
    private GroupDirectoryContextHelper _directoryContextHelper;
    private PopulationContextHelper _populationContextHelper;
    private UserPopulationDAO _userPopulationDAO;
    private GroupHelper _groupHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._groupDirectoryDAO = (GroupDirectoryDAO)manager.lookup(GroupDirectoryDAO.ROLE);
        this._directoryContextHelper = (GroupDirectoryContextHelper)manager.lookup(GroupDirectoryContextHelper.ROLE);
        this._populationContextHelper = (PopulationContextHelper)manager.lookup(PopulationContextHelper.ROLE);
        this._groupHelper = (GroupHelper)manager.lookup(GroupHelper.ROLE);
    }

    public Map<String, Object> searchUsersAndGroupByContext(Set<String> contexts, int limit, Map<String, Object> searchData, Map<String, Object> params, boolean sort) {
        Set<String> groupDirectories = this._directoryContextHelper.getGroupDirectoriesOnContexts(contexts);
        Set<String> userPopulations = this._populationContextHelper.getUserPopulationsOnContexts(contexts, false, true);
        return this.searchUsersAndGroup(userPopulations, groupDirectories, limit, searchData, params, sort);
    }

    public Map<String, Object> searchUsersAndGroup(Set<String> availablePopulations, Set<String> availableDirectories, int limit, Map<String, Object> searchData, Map<String, Object> params, boolean sort) {
        Map<String, Integer> usersFromSearchData = this._getFromSearchData("users", searchData);
        Set<String> userPopulations = usersFromSearchData == null ? availablePopulations : this._filterSetUnion(availablePopulations, usersFromSearchData.keySet());
        Map<String, Integer> groupsFromSearchData = this._getFromSearchData("groups", searchData);
        Set<String> groupDirectories = groupsFromSearchData == null ? availableDirectories : this._filterSetUnion(availableDirectories, groupsFromSearchData.keySet());
        Function<UserPopulation, Integer> getPopulationOffset = population -> usersFromSearchData != null ? usersFromSearchData.getOrDefault(population.getId(), 0) : 0;
        Function<GroupDirectory, Integer> getDirectoryOffset = directory -> groupsFromSearchData != null ? groupsFromSearchData.getOrDefault(directory.getId(), 0) : 0;
        int count = limit <= 0 ? 20 : limit;
        List<SearchDataResult> searchDataResults = Stream.concat(userPopulations.stream().map(this._userPopulationDAO::getUserPopulation).filter(Objects::nonNull).map(population -> this._searchUsers((UserPopulation)population, count, (Integer)getPopulationOffset.apply((UserPopulation)population), params, sort)), groupDirectories.stream().map(this._groupDirectoryDAO::getGroupDirectory).filter(Objects::nonNull).map(directory -> this._searchGroups((GroupDirectory)directory, count, (Integer)getDirectoryOffset.apply((GroupDirectory)directory), params))).collect(Collectors.toList());
        if (searchDataResults.size() == 0) {
            return this._formatSearchResults(Collections.emptyList(), null);
        }
        if (searchDataResults.size() == 1) {
            SearchDataResult searchDataResult2 = (SearchDataResult)searchDataResults.get(0);
            return this._formatSearchResults(searchDataResult2.results2Json(), searchDataResult2.isFinished() ? null : searchDataResults);
        }
        if (searchDataResults.stream().allMatch(SearchDataResult::isFinished)) {
            return this._formatSearchResults(this._mergeSearchResults(searchDataResults), null);
        }
        searchDataResults = searchDataResults.stream().filter(searchDataResult -> searchDataResult.getLastSortableName() != null).sorted(Comparator.comparing(SearchDataResult::getLastSortableName)).collect(Collectors.toList());
        String entryDelimitor = null;
        for (SearchDataResult searchDataResult3 : searchDataResults) {
            if (entryDelimitor != null) {
                searchDataResult3.truncateAfter(entryDelimitor);
                continue;
            }
            if (searchDataResult3.isFinished()) continue;
            entryDelimitor = searchDataResult3.getLastSortableName();
        }
        List<SearchDataResult> unfinishedSearchDataResults = searchDataResults.stream().filter(searchDataResult -> !searchDataResult.isFinished()).collect(Collectors.toList());
        return this._formatSearchResults(this._mergeSearchResults(searchDataResults), unfinishedSearchDataResults);
    }

    private Map<String, Integer> _getFromSearchData(String property, Map<String, Object> searchData) {
        if (searchData == null) {
            return null;
        }
        return Optional.ofNullable(searchData.getOrDefault(property, null)).filter(Map.class::isInstance).map(Map.class::cast).orElse(Collections.emptyMap());
    }

    private Set<String> _filterSetUnion(Set<String> values, Set<String> referenceSet) {
        return values.stream().filter(referenceSet::contains).collect(Collectors.toSet());
    }

    private SearchDataResult _searchUsers(UserPopulation population, int limit, int offset, Map<String, Object> params, boolean sort) {
        ArrayList<User> users = new ArrayList<User>(this._userManager.getUsers(population, limit, offset, params, sort));
        return new PopulationSearchDataResult(this._userHelper, population.getId(), users.size() < limit, users, offset);
    }

    private SearchDataResult _searchGroups(GroupDirectory directory, int limit, int offset, Map<String, Object> params) {
        List<Group> groups = directory.getGroups(limit, offset, params);
        return new DirectorySearchDataResult(this._groupHelper, directory.getId(), groups.size() < limit, groups, offset);
    }

    private Map<String, Object> _formatSearchResults(List<Map<String, Object>> results, List<SearchDataResult> searchDataResults) {
        HashMap<String, Object> jsonResult = new HashMap<String, Object>();
        jsonResult.put("results", results);
        if (searchDataResults == null) {
            jsonResult.put("finished", true);
        } else {
            HashMap searchDataJson = new HashMap();
            for (SearchDataResult searchDataResult : searchDataResults) {
                String type = searchDataResult.getType();
                if (!searchDataJson.containsKey(type)) {
                    searchDataJson.put(type, new HashMap());
                }
                ((Map)searchDataJson.get(type)).put(searchDataResult.getSourceId(), searchDataResult.getOffset());
            }
            if (searchDataJson.size() > 0) {
                jsonResult.put("searchData", searchDataJson);
            } else {
                jsonResult.put("finished", true);
            }
        }
        return jsonResult;
    }

    private List<Map<String, Object>> _mergeSearchResults(List<SearchDataResult> searchDataResults) {
        return searchDataResults.stream().map(SearchDataResult::results2Json).flatMap(Collection::stream).sorted((o1, o2) -> UserAndGroupSearchManager._getSortableName(o1).compareTo(UserAndGroupSearchManager._getSortableName(o2))).collect(Collectors.toList());
    }

    protected static String _getSortableName(Map<String, Object> o) {
        if (o.containsKey("sortablename")) {
            return ((String)o.get("sortablename")).toLowerCase();
        }
        if (o.containsKey("label")) {
            return ((String)o.get("label")).toLowerCase();
        }
        return "";
    }

    private static interface SearchDataResult {
        public String getType();

        public String getSourceId();

        public boolean isFinished();

        public void truncateAfter(String var1);

        public int getOffset();

        public List<Map<String, Object>> results2Json();

        public String getLastSortableName();
    }

    private static class PopulationSearchDataResult
    implements SearchDataResult {
        private boolean _isFinished;
        private List<User> _users;
        private int _offset;
        private UserHelper _helper;
        private String _sourceId;

        public PopulationSearchDataResult(UserHelper userHelper, String sourceId, boolean isFinished, List<User> users, int initialOffset) {
            this._helper = userHelper;
            this._sourceId = sourceId;
            this._isFinished = isFinished;
            this._users = users;
            this._offset = initialOffset;
        }

        @Override
        public String getType() {
            return "users";
        }

        @Override
        public String getSourceId() {
            return this._sourceId;
        }

        @Override
        public boolean isFinished() {
            return this._isFinished;
        }

        @Override
        public void truncateAfter(String entry) {
            if (this._users.removeIf(user -> user.getSortableName().toLowerCase().compareTo(entry) > 0)) {
                this._isFinished = false;
            }
        }

        @Override
        public int getOffset() {
            return this._offset + this._users.size();
        }

        @Override
        public List<Map<String, Object>> results2Json() {
            return this._helper.users2json(this._users, true);
        }

        @Override
        public String getLastSortableName() {
            return this._users.size() > 0 ? this._users.get(this._users.size() - 1).getSortableName().toLowerCase() : null;
        }

        public String toString() {
            return SearchDataResult.class.getName() + "@" + Integer.toHexString(this.hashCode()) + "[" + this._users.size() + " user(s) from population " + this._sourceId + " at offset " + this._offset + "]" + (this._isFinished ? "[Finished]" : "");
        }
    }

    private static class DirectorySearchDataResult
    implements SearchDataResult {
        private String _sourceId;
        private boolean _isFinished;
        private List<Group> _groups;
        private int _offset;
        private GroupHelper _helper;

        public DirectorySearchDataResult(GroupHelper helper, String sourceId, boolean isFinished, List<Group> groups, int initialOffset) {
            this._helper = helper;
            this._sourceId = sourceId;
            this._isFinished = isFinished;
            this._groups = new ArrayList<Group>(groups);
            this._offset = initialOffset;
        }

        @Override
        public String getType() {
            return "groups";
        }

        @Override
        public String getSourceId() {
            return this._sourceId;
        }

        @Override
        public boolean isFinished() {
            return this._isFinished;
        }

        @Override
        public void truncateAfter(String entry) {
            if (this._groups.removeIf(group -> group.getLabel().toLowerCase().compareTo(entry) > 0)) {
                this._isFinished = false;
            }
        }

        @Override
        public int getOffset() {
            return this._offset + this._groups.size();
        }

        @Override
        public List<Map<String, Object>> results2Json() {
            return this._helper.groups2JSON(this._groups, false);
        }

        @Override
        public String getLastSortableName() {
            return this._groups.size() > 0 ? this._groups.get(this._groups.size() - 1).getLabel().toLowerCase() : null;
        }

        public String toString() {
            return SearchDataResult.class.getName() + "@" + Integer.toHexString(this.hashCode()) + "[" + this._groups.size() + " group(s) from directory " + this._sourceId + " at offset " + this._offset + "]" + (this._isFinished ? "[Finished]" : "");
        }
    }
}

