/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.ClientSideElementDependenciesManager;
import org.ametys.core.ui.MessageTargetFactoriesManager;
import org.ametys.core.ui.RelationsManager;
import org.ametys.core.ui.RibbonConfigurationManager;
import org.ametys.core.ui.RibbonControlsManager;
import org.ametys.core.ui.RibbonImportManager;
import org.ametys.core.ui.RibbonManager;
import org.ametys.core.ui.RibbonManagerCache;
import org.ametys.core.ui.RibbonTabsManager;
import org.ametys.core.ui.SAXClientSideElementHelper;
import org.ametys.core.ui.StaticFileImportsManager;
import org.ametys.core.ui.UIToolsConfigurationManager;
import org.ametys.core.ui.UIToolsFactoriesManager;
import org.ametys.core.ui.ribbonconfiguration.RibbonConfigurationSource;
import org.ametys.core.ui.widgets.ClientSideWidget;
import org.ametys.core.ui.widgets.WidgetsManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.servlet.RuntimeServlet;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class WorkspaceGenerator
extends ServiceableGenerator {
    protected RibbonControlsManager _ribbonControlManager;
    protected RibbonTabsManager _ribbonTabManager;
    protected UIToolsFactoriesManager _uitoolsFactoriesManager;
    protected WidgetsManager _widgetsManager;
    protected SAXClientSideElementHelper _saxClientSideElementHelper;
    protected SourceResolver _resolver;
    protected CurrentUserProvider _currentUserProvider;
    protected JSONUtils _jsonUtils;
    protected UserHelper _userHelper;
    protected RibbonManagerCache _ribbonManagerCache;
    protected RibbonImportManager _ribbonImportManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._uitoolsFactoriesManager = (UIToolsFactoriesManager)smanager.lookup(UIToolsFactoriesManager.ROLE);
        this._ribbonTabManager = (RibbonTabsManager)smanager.lookup(RibbonTabsManager.ROLE);
        this._ribbonControlManager = (RibbonControlsManager)smanager.lookup(RibbonControlsManager.ROLE);
        this._widgetsManager = (WidgetsManager)smanager.lookup(WidgetsManager.ROLE);
        this._saxClientSideElementHelper = (SAXClientSideElementHelper)smanager.lookup(SAXClientSideElementHelper.ROLE);
        this._resolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
        this._ribbonManagerCache = (RibbonManagerCache)smanager.lookup(RibbonManagerCache.ROLE);
        this._ribbonImportManager = (RibbonImportManager)smanager.lookup(RibbonImportManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.doGenerate(this.getContextualParameters());
    }

    protected Map<String, Object> getContextualParameters() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String workspaceName = (String)request.getAttribute("workspaceName");
        HashMap<String, Object> contextParameters = new HashMap<String, Object>();
        contextParameters.put("workspaceName", workspaceName);
        return contextParameters;
    }

    protected void doGenerate(Map<String, Object> contextParameters) throws IOException, SAXException, ProcessingException {
        Map<String, List<ClientSideElement>> elementsToSax;
        long startTime = new Date().getTime();
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"workspace");
        UserIdentity currentUser = this._currentUserProvider.getUser();
        if (currentUser != null && StringUtils.isNotBlank((CharSequence)currentUser.getLogin())) {
            this._userHelper.saxUserIdentity(currentUser, this.contentHandler);
        }
        ClientSideElementDependenciesManager dependenciesManager = new ClientSideElementDependenciesManager(this.manager);
        RibbonConfigurationSource ribbonConfig = this.getRibbonConfiguration();
        RibbonManager ribbonManager = null;
        try {
            ribbonManager = this._ribbonManagerCache.getManager(ribbonConfig.getUri());
            String workspaceName = (String)ObjectModelHelper.getRequest((Map)this.objectModel).getAttribute("workspaceName");
            RibbonConfigurationManager ribbonConfigurationManager = new RibbonConfigurationManager();
            ribbonConfigurationManager.setup(this._ribbonControlManager, this._ribbonTabManager, this._ribbonImportManager, this._saxClientSideElementHelper, this._resolver, this._ribbonManagerCache);
            ribbonConfigurationManager.configure(ribbonManager, dependenciesManager, ribbonConfig, workspaceName);
            Map<String, Set<String>> effectivelySaxedElements = ribbonConfigurationManager.saxRibbonDefinition(this.contentHandler, contextParameters);
            elementsToSax = this.getElementsToSax(dependenciesManager, ribbonConfigurationManager, contextParameters, effectivelySaxedElements);
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to get or create a ribbon manager for ribbon specific components", (Throwable)e);
        }
        finally {
            this._ribbonManagerCache.dispose(ribbonManager);
        }
        this.saxUITools(contextParameters, elementsToSax.get(UIToolsFactoriesManager.ROLE));
        this.saxMessageTargetFactories(contextParameters, elementsToSax.get(MessageTargetFactoriesManager.ROLE));
        this.saxRelationsHandlers(contextParameters, elementsToSax.get(RelationsManager.ROLE));
        this.saxWidgets(contextParameters);
        this.saxStaticFileImports(contextParameters, elementsToSax.get(StaticFileImportsManager.ROLE));
        this.saxAdditionnalInfo(contextParameters);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"workspace");
        this.contentHandler.endDocument();
        long endTime = new Date().getTime();
        this.getLogger().debug("Workspace generated in " + (endTime - startTime) + " ms");
    }

    protected Map<String, List<ClientSideElement>> getElementsToSax(ClientSideElementDependenciesManager dependenciesManager, RibbonConfigurationManager ribbonManager, Map<String, Object> contextParameters, Map<String, Set<String>> effectivelySaxedElements) throws SAXException {
        Set<String> effectivelySaxedControls = effectivelySaxedElements.get("controls");
        List<ClientSideElement> ribbonControls = ribbonManager.getControls(contextParameters);
        for (ClientSideElement clientSideElement : ribbonControls) {
            if (!effectivelySaxedControls.contains(clientSideElement.getId())) continue;
            dependenciesManager.register(clientSideElement);
        }
        List<ClientSideElement> ribbonTabs = ribbonManager.getTabs();
        for (ClientSideElement control : ribbonTabs) {
            dependenciesManager.register(control);
        }
        for (String extensionId : this._widgetsManager.getExtensionsIds()) {
            ClientSideWidget element = (ClientSideWidget)this._widgetsManager.getExtension(extensionId);
            dependenciesManager.register(element);
        }
        try {
            return dependenciesManager.computeDependencies();
        }
        catch (ServiceException serviceException) {
            throw new SAXException("Unable to compute dependencies", (Exception)((Object)serviceException));
        }
    }

    protected void saxUITools(Map<String, Object> contextParameters, List<ClientSideElement> elements) throws IOException, SAXException {
        Source configSource = this.getUIToolsConfiguration();
        UIToolsConfigurationManager uitoolsManager = new UIToolsConfigurationManager(this._uitoolsFactoriesManager, this._saxClientSideElementHelper, configSource, ObjectModelHelper.getRequest((Map)this.objectModel));
        uitoolsManager.saxDefaultState(this.contentHandler, contextParameters, elements);
    }

    protected RibbonConfigurationSource getRibbonConfiguration() throws IOException {
        String ribbonFileName = this.parameters.getParameter("ribbonFileName", "ribbon");
        String mode = this.parameters.getParameter("mode", null);
        return RibbonConfigurationSource.createFromUri("context://WEB-INF/param/" + ribbonFileName + (String)(mode != null ? "-" + mode : "") + ".xml", this._resolver);
    }

    protected Source getUIToolsConfiguration() throws IOException {
        String toolsFileName = this.parameters.getParameter("toolsFileName", "uitools");
        String mode = this.parameters.getParameter("mode", null);
        return this._resolver.resolveURI("context://WEB-INF/param/" + toolsFileName + (String)(mode != null ? "-" + mode : "") + ".xml");
    }

    protected void saxMessageTargetFactories(Map<String, Object> contextParameters, List<ClientSideElement> elements) throws SAXException {
        this.contentHandler.startPrefixMapping("i18n", "http://apache.org/cocoon/i18n/2.1");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"messagetarget-factories");
        if (elements != null) {
            for (ClientSideElement element : elements) {
                this._saxClientSideElementHelper.saxDefinition("messagetarget-factory", element, MessageTargetFactoriesManager.ROLE, this.contentHandler, contextParameters);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"messagetarget-factories");
        this.contentHandler.endPrefixMapping("i18n");
    }

    protected void saxRelationsHandlers(Map<String, Object> contextParameters, List<ClientSideElement> elements) throws SAXException {
        this.contentHandler.startPrefixMapping("i18n", "http://apache.org/cocoon/i18n/2.1");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"relations-handlers");
        if (elements != null) {
            for (ClientSideElement element : elements) {
                this._saxClientSideElementHelper.saxDefinition("relation-handler", element, RelationsManager.ROLE, this.contentHandler, contextParameters);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"relations-handlers");
        this.contentHandler.endPrefixMapping("i18n");
    }

    protected void saxWidgets(Map<String, Object> contextParameters) throws SAXException {
        this.contentHandler.startPrefixMapping("i18n", "http://apache.org/cocoon/i18n/2.1");
        Map<String, Map<String, Map<String, String>>> defaultWidgets = this._widgetsManager.getDefaultWidgets();
        AttributesImpl wattrs = new AttributesImpl();
        wattrs.addCDATAAttribute("default-widgets", this._jsonUtils.convertObjectToJson(defaultWidgets));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"widgets", (Attributes)wattrs);
        for (String extensionId : this._widgetsManager.getExtensionsIds()) {
            ClientSideWidget element = (ClientSideWidget)this._widgetsManager.getExtension(extensionId);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("ftypes", StringUtils.join((Object[])element.getFormTypes(contextParameters), (String)","));
            attrs.addCDATAAttribute("supports-enumerated", Boolean.toString(element.supportsEnumerated(contextParameters)));
            attrs.addCDATAAttribute("supports-non-enumerated", Boolean.toString(element.supportsNonEnumerated(contextParameters)));
            attrs.addCDATAAttribute("supports-multiple", Boolean.toString(element.supportsMultiple(contextParameters)));
            attrs.addCDATAAttribute("supports-non-multiple", Boolean.toString(element.supportsNonMultiple(contextParameters)));
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"widget-wrapper", (Attributes)attrs);
            this._saxClientSideElementHelper.saxDefinition("widget", element, WidgetsManager.ROLE, this.contentHandler, contextParameters);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"widget-wrapper");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"widgets");
        this.contentHandler.endPrefixMapping("i18n");
    }

    protected void saxStaticFileImports(Map<String, Object> contextParameters, List<ClientSideElement> elements) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"static-imports");
        if (elements != null) {
            for (ClientSideElement element : elements) {
                this._saxClientSideElementHelper.saxDefinition("import", element, StaticFileImportsManager.ROLE, this.contentHandler, contextParameters);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"static-imports");
    }

    protected void saxAdditionnalInfo(Map<String, Object> contextParameters) throws SAXException {
        if (PluginsManager.getInstance().isSafeMode()) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"safe-mode", (String)PluginsManager.getInstance().getStatus().toString());
        }
        if (RuntimeServlet.getRunMode() == RuntimeServlet.RunMode.MAINTENANCE) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"maintenance");
        }
    }
}

