/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.authentication;

import java.util.List;
import java.util.Map;
import org.ametys.core.authentication.AuthenticateAction;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.core.impl.authentication.FormCredentialProvider;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class MultifactorAuthenticationClientSideElement
extends StaticClientSideElement
implements Contextualizable {
    protected Context _context;
    protected UserManager _userManager;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
    }

    @Override
    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        UserIdentity userIdentity;
        User user;
        String recipient;
        FormCredentialProvider formCredentialProvider;
        Request request = ContextHelper.getRequest((Context)this._context);
        CredentialProvider credentialProvider = AuthenticateAction.getCredentialProviderFromSession(request);
        if (credentialProvider instanceof FormCredentialProvider && (formCredentialProvider = (FormCredentialProvider)credentialProvider).useMultifactorAuthentication() && !StringUtils.isEmpty((CharSequence)(recipient = (user = this._userManager.getUser(userIdentity = this._currentUserProvider.getUser())).getEmail()))) {
            return super.getScripts(ignoreRights, contextParameters);
        }
        return List.of();
    }
}

