/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.glyph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.core.ui.glyph.CssFontHelper;
import org.ametys.plugins.core.ui.glyph.GlyphProvider;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ApplicationGlyphManager
extends AbstractThreadSafeComponentExtensionPoint<GlyphProvider> {
    private CssFontHelper _cssFontHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._cssFontHelper = (CssFontHelper)smanager.lookup(CssFontHelper.ROLE);
    }

    @Callable(rights={"*"})
    public boolean hasGlyphs() {
        return !this.getGlyphs().isEmpty();
    }

    @Callable(rights={"*"})
    public List<Map<String, List<String>>> getGlyphsStore() {
        ArrayList<Map<String, List<String>>> glyphs = new ArrayList<Map<String, List<String>>>();
        Collection<List<String>> glyphClassNames = this.getGlyphs();
        for (List<String> similarGlyphClassNames : glyphClassNames) {
            HashMap<String, List<String>> glyph = new HashMap<String, List<String>>();
            glyph.put("cssClassName", similarGlyphClassNames);
            glyphs.add(glyph);
        }
        return glyphs;
    }

    public Collection<List<String>> getGlyphs() {
        LinkedHashSet<List<String>> glyphs = new LinkedHashSet<List<String>>();
        for (String id : this.getExtensionsIds()) {
            GlyphProvider glyphProvider = (GlyphProvider)this.getExtension(id);
            Map<String, String> cssFiles = glyphProvider.getCSSFiles();
            for (Map.Entry<String, String> cssFile : cssFiles.entrySet()) {
                String cssFileURI = cssFile.getKey();
                String prefix = cssFile.getValue();
                glyphs.addAll(this._cssFontHelper.getGlyphClassNames(cssFileURI, prefix));
            }
        }
        return glyphs;
    }
}

