/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.glyph;

import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS3;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CssFontHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = CssFontHelper.class.getName();
    private static final Pattern __CSS_CLASS_NAME = Pattern.compile("\\.-?[_a-zA-Z]+[_a-zA-Z0-9-.]*");
    private SourceResolver _resolver;
    private Map<String, Long> _lastUpdates = new HashMap<String, Long>();
    private Map<String, Collection<List<String>>> _glyphs = new HashMap<String, Collection<List<String>>>();

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<List<String>> getGlyphClassNames(String cssURI, String prefix) {
        Source cssSource = null;
        try {
            cssSource = this._resolver.resolveURI(cssURI);
            if (cssSource.exists()) {
                Long lastUpdate = this._lastUpdates.get(cssSource.getURI());
                if (lastUpdate == null || lastUpdate < cssSource.getLastModified()) {
                    Collection<List<String>> classNames = this._getGlyphClassNames(cssSource, prefix);
                    this.getLogger().debug("Found {} glyphes into CSS file {}", (Object)classNames.size(), (Object)cssSource.getURI());
                    this._lastUpdates.put(cssSource.getURI(), cssSource.getLastModified());
                    this._glyphs.put(cssSource.getURI(), classNames);
                }
                Collection<List<String>> collection = this._glyphs.get(cssSource.getURI());
                return collection;
            }
            try {
                throw new SourceNotFoundException("The CSS file " + cssURI + " does not exist");
            }
            catch (SourceNotFoundException e) {
                this.getLogger().warn("The CSS file at uri <{}> does not exist. It will be ignored.", (Object)cssURI, (Object)e);
            }
            catch (IOException e) {
                this.getLogger().warn("Fail to read the CSS file at uri <{}>. It will be ignored.", (Object)cssURI, (Object)e);
            }
        }
        finally {
            this._resolver.release(cssSource);
        }
        return Collections.EMPTY_SET;
    }

    private Collection<List<String>> _getGlyphClassNames(Source cssSource, String prefix) throws IOException {
        LinkedHashMap<String, List> classNames = new LinkedHashMap<String, List>();
        CSSStyleSheet styleSheet = this._getCssStyleSheet(cssSource);
        Set<String> commonClassNames = this.getFontClassNames(styleSheet);
        CSSRuleList rules = styleSheet.getCssRules();
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSStyleDeclaration style;
            String chars;
            CSSRule rule = rules.item(i);
            if (!(rule instanceof CSSStyleRule) || !StringUtils.isNotEmpty((CharSequence)(chars = (style = ((CSSStyleRule)rule).getStyle()).getPropertyValue("content")))) continue;
            String selectorText = ((CSSStyleRule)rule).getSelectorText();
            Matcher matcher = __CSS_CLASS_NAME.matcher(selectorText);
            while (matcher.find()) {
                String className = matcher.group().substring(1).replace(".", " ");
                if (commonClassNames.isEmpty() && (StringUtils.isNotBlank((CharSequence)prefix) && className.startsWith(prefix) || StringUtils.isBlank((CharSequence)prefix))) {
                    classNames.computeIfAbsent(chars, c -> new ArrayList()).add(className);
                    continue;
                }
                if (commonClassNames.contains(className)) {
                    classNames.computeIfAbsent(chars, c -> new ArrayList()).add(className);
                    continue;
                }
                for (String commonClassName : commonClassNames) {
                    Object computedClassName = commonClassName + " " + className;
                    computedClassName = Arrays.stream(((String)computedClassName).split(" ")).distinct().collect(Collectors.joining(" "));
                    if ((!StringUtils.isNotBlank((CharSequence)prefix) || !((String)computedClassName).startsWith(prefix)) && !StringUtils.isBlank((CharSequence)prefix)) continue;
                    classNames.computeIfAbsent(chars, c -> new ArrayList()).add(computedClassName);
                }
            }
        }
        return classNames.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFontFaceRule(String cssURI) {
        block8: {
            Source cssSource = null;
            try {
                cssSource = this._resolver.resolveURI(cssURI);
                if (!cssSource.exists()) break block8;
                Long lastUpdate = this._lastUpdates.get(cssSource.getURI());
                if (lastUpdate == null || lastUpdate < cssSource.getLastModified()) {
                    CSSStyleSheet cssStyleSheet = this._getCssStyleSheet(cssSource);
                    CSSRuleList cssRules = cssStyleSheet.getCssRules();
                    for (int i = 0; i < cssRules.getLength(); ++i) {
                        CSSRule cssRule = cssRules.item(i);
                        if (!(cssRule instanceof CSSFontFaceRule)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    break block8;
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                this.getLogger().warn("Fail to read the CSS file at uri <{}>.", (Object)cssURI, (Object)e);
            }
            finally {
                this._resolver.release(cssSource);
            }
        }
        return false;
    }

    public Set<String> getFontClassNames(CSSStyleSheet styleSheet) {
        CSSRuleList rules = styleSheet.getCssRules();
        HashSet<String> fontClassNames = new HashSet<String>();
        Set<String> fontFamilies = this._getFontFamily(styleSheet);
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSStyleRule styleRule;
            CSSStyleDeclaration style;
            CSSRule rule = rules.item(i);
            if (!(rule instanceof CSSStyleRule) || !StringUtils.isEmpty((CharSequence)(style = (styleRule = (CSSStyleRule)rule).getStyle()).getPropertyValue("content")) || !this._matchFontFamily(fontFamilies, style)) continue;
            String selectorText = styleRule.getSelectorText();
            Matcher matcher = __CSS_CLASS_NAME.matcher(selectorText);
            while (matcher.find()) {
                fontClassNames.add(matcher.group().substring(1));
            }
        }
        return fontClassNames;
    }

    private boolean _matchFontFamily(Set<String> fontFamilies, CSSStyleDeclaration style) {
        String fontValue = style.getPropertyValue("font");
        String fontFamilyValue = style.getPropertyValue("font-family");
        if (StringUtils.isNotBlank((CharSequence)fontValue) || StringUtils.isNotBlank((CharSequence)fontFamilyValue)) {
            for (String fontFamily : fontFamilies) {
                if ((!StringUtils.isNotBlank((CharSequence)fontValue) || !fontValue.contains(fontFamily)) && (!StringUtils.isNotBlank((CharSequence)fontFamilyValue) || !fontFamilyValue.contains(fontFamily))) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CSSStyleSheet _getCssStyleSheet(Source source) throws MalformedURLException, IOException {
        try {
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(source.getInputStream());
            inputSource.setEncoding("UTF-8");
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
            CSSStyleSheet cSSStyleSheet = parser.parseStyleSheet(inputSource, null, null);
            return cSSStyleSheet;
        }
        finally {
            this._resolver.release(source);
        }
    }

    private Set<String> _getFontFamily(CSSStyleSheet styleSheet) {
        HashSet<String> fontsFamily = new HashSet<String>();
        CSSRuleList cssRules = styleSheet.getCssRules();
        for (int i = 0; i < cssRules.getLength(); ++i) {
            CSSRule cssRule = cssRules.item(i);
            if (!(cssRule instanceof CSSFontFaceRule)) continue;
            CSSStyleDeclaration style = ((CSSFontFaceRule)cssRule).getStyle();
            String fontFamily = style.getPropertyValue("font-family");
            fontsFamily.add(StringUtils.strip((String)StringUtils.strip((String)fontFamily, (String)"\""), (String)"'"));
        }
        return fontsFamily;
    }
}

