/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.log;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.ui.log.parser.LogFileParser;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class ArchivedLogClientSideElement
extends StaticClientSideElement {
    protected JSONUtils _jsonUtils;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> getLogLines(String logFileName, String filtersJson, Integer limit) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        File logFile = new File(this.getLogsDirectory(), logFileName);
        if (logFile.exists()) {
            try {
                result.put("lines", LogFileParser.parseFile(logFile, this._convertFilters(filtersJson), limit, this.getLogger()));
            }
            catch (IOException e) {
                String errorMessage = String.format("An error occurs while parsing the log file '%s'.", logFileName);
                result.put("error", errorMessage);
                this.getLogger().error(errorMessage, (Throwable)e);
            }
        } else {
            result.put("error", String.format("The file '%s' doesn't exists in the logs directory.", logFileName));
        }
        return result;
    }

    protected File getLogsDirectory() {
        return new File(AmetysHomeHelper.getAmetysHome(), "logs");
    }

    private Map<String, Object> _convertFilters(String filtersJson) {
        HashMap<String, Object> filtersAsMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)filtersJson)) {
            List<Object> filtersAsList = this._jsonUtils.convertJsonToList(filtersJson);
            for (Object filterObject : filtersAsList) {
                Map filterMap = (Map)filterObject;
                filtersAsMap.put(filterMap.get("property").toString(), filterMap.get("value"));
            }
        }
        return filtersAsMap;
    }
}

