/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.minimize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.ametys.core.DevMode;
import org.ametys.core.resources.ProxiedContextPathProvider;
import org.ametys.plugins.core.ui.minimize.HashCache;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.xml.sax.SAXException;

public abstract class AbstractMinimizeReader
extends ServiceableReader
implements CacheableProcessingComponent {
    private HashCache _hashCache;
    private ProxiedContextPathProvider _proxiedContextPathProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._hashCache = (HashCache)smanager.lookup(HashCache.ROLE);
        this._proxiedContextPathProvider = (ProxiedContextPathProvider)this.manager.lookup(ProxiedContextPathProvider.ROLE);
    }

    public Serializable getKey() {
        return this.source + "*" + this._proxiedContextPathProvider.getContextPath();
    }

    public SourceValidity getValidity() {
        return new NOPValidity();
    }

    public long getLastModified() {
        return 1000L;
    }

    public void setup(SourceResolver res, Map obj, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(res, obj, src, par);
        Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
        response.setHeader("Cache-Control", "max-age=31536000, immutable");
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        List<HashCache.UriData> files = this._hashCache.getFilesForHash(this.source, true);
        if (files == null) {
            throw new ResourceNotFoundException("There is no list of file to minimize for hashcode '" + this.source + "'");
        }
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        boolean generateSourceMap = !DevMode.DEVMODE.PRODUCTION.equals((Object)DevMode.getDeveloperMode(request));
        String str = this._handleFiles(files, generateSourceMap);
        IOUtils.write((String)str, (OutputStream)this.out, (Charset)StandardCharsets.UTF_8);
        this.out.flush();
    }

    protected abstract String _handleFiles(List<HashCache.UriData> var1, boolean var2);
}

