/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.minimize;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ametys.core.DevMode;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.plugins.core.ui.resources.ResourceDependenciesListExtensionPoint;
import org.ametys.plugins.core.ui.util.RequestAttributesHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.Strings;

public class HashCache
extends AbstractLogEnabled
implements Component,
Contextualizable,
Serviceable,
Initializable {
    public static final String ROLE = HashCache.class.getName();
    protected RequestAttributesHelper _requestAttributesHelper;
    protected ResourceDependenciesListExtensionPoint _resourceDependenciesListEP;
    protected AbstractCacheManager _cacheManager;
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._requestAttributesHelper = (RequestAttributesHelper)manager.lookup(RequestAttributesHelper.ROLE);
        this._resourceDependenciesListEP = (ResourceDependenciesListExtensionPoint)manager.lookup(ResourceDependenciesListExtensionPoint.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createMemoryCache(ROLE, new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_HASH_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_HASH_DESCRIPTION"), true, null);
    }

    public List<UriData> getFilesForHash(String hash, boolean firstLevel) {
        List<UriData> uriDataList = this._getCache().get(hash);
        if (firstLevel && uriDataList != null) {
            return uriDataList.stream().filter(UriData::isFirstLevel).toList();
        }
        return uriDataList;
    }

    public String createHash(Map<String, Map<String, String>> files, String salt) throws IllegalArgumentException {
        List<Object> hashCache = new ArrayList();
        Map<String, Object> attributes = this._requestAttributesHelper.saveRequestAttributes();
        try {
            Request request = ContextHelper.getRequest((Context)this._context);
            DevMode.DEVMODE developerMode = DevMode.getDeveloperMode(request);
            hashCache = this._getFiles(files, developerMode == DevMode.DEVMODE.PRODUCTION);
            String hash = Base64.getEncoder().withoutPadding().encodeToString(String.valueOf(31 * hashCache.hashCode() + salt.hashCode()).getBytes("UTF-8"));
            if (developerMode == DevMode.DEVMODE.PRODUCTION) {
                if (!this._getCache().hasKey(hash)) {
                    hashCache = this._getFiles(files, false);
                    this._getCache().put(hash, hashCache);
                }
            } else {
                this._getCache().put(hash, hashCache);
            }
            String string = hash;
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            this._requestAttributesHelper.restoreRequestAttributes(attributes);
        }
    }

    private List<UriData> _getFiles(Map<String, Map<String, String>> files, boolean onlyFirstLevel) {
        return files.entrySet().stream().map(file -> this._resourceDependenciesListEP.getDependencies((String)file.getKey(), (Map)file.getValue(), onlyFirstLevel)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Cache<String, List<UriData>> _getCache() {
        return this._cacheManager.get(ROLE);
    }

    public static class UriData {
        private String _uri;
        private Long _lastModified;
        private String _media;
        private boolean _firstLevel;

        public UriData(String uri, boolean firstLevel) {
            this._uri = uri;
            this._firstLevel = firstLevel;
        }

        public void setLastModified(Long lastModified) {
            this._lastModified = lastModified;
        }

        public void setMedia(String media) {
            this._media = media;
        }

        public String getUri() {
            return this._uri;
        }

        public Long getLastModified() {
            return this._lastModified;
        }

        public String getMedia() {
            return this._media;
        }

        public boolean isFirstLevel() {
            return this._firstLevel;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UriData) {
                UriData fObj = (UriData)obj;
                return Strings.CS.equals(this._uri, fObj._uri) && (this._lastModified == null ? fObj._lastModified == null : this._lastModified.equals(fObj._lastModified)) && Strings.CS.equals(this._media, fObj._media);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this._uri, this._lastModified, this._media);
        }

        public String toString() {
            if (this._media != null) {
                return this._uri + "#" + this._media + " (" + this._lastModified + ")";
            }
            return this._uri + " (" + this._lastModified + ")";
        }
    }
}

