/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.parameter.files;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.util.DateUtils;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;

public abstract class AbstractGetFilesAction
extends ServiceableAction
implements Contextualizable {
    protected Context _cocoonContext;
    protected SourceResolver _srcResolver;

    public void service(ServiceManager smanager) throws ServiceException {
        this._srcResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public Map act(Redirector redirector, org.apache.cocoon.environment.SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String path = Objects.toString(request.getParameter("path"), "");
        String rootURI = this.getRootURI(request);
        TraversableSource rootDir = (TraversableSource)this._srcResolver.resolveURI(rootURI);
        TraversableSource currentDir = (TraversableSource)this._srcResolver.resolveURI(rootURI + (String)(path.length() > 0 ? "/" + path : ""));
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        if (currentDir.exists()) {
            for (TraversableSource child : currentDir.getChildren()) {
                if (this.isIgnoredSource(child)) continue;
                if (child.isCollection()) {
                    nodes.add(this._collection2JsonObject(child, rootDir));
                    continue;
                }
                nodes.add(this._resource2JsonObject(child, rootDir));
            }
        }
        HashMap<String, ArrayList<Map<String, Object>>> result = new HashMap<String, ArrayList<Map<String, Object>>>();
        result.put("nodes", nodes);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected abstract String getRootURI(Request var1);

    protected boolean isIgnoredSource(TraversableSource source) {
        return false;
    }

    protected Map<String, Object> _collection2JsonObject(TraversableSource folder, TraversableSource root) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("type", "collection");
        jsonObject.put("name", folder.getName());
        jsonObject.put("path", this._getRelativePath(root, folder));
        return jsonObject;
    }

    protected Map<String, Object> _resource2JsonObject(TraversableSource file, TraversableSource root) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("type", "resource");
        jsonObject.put("name", file.getName());
        jsonObject.put("path", this._getRelativePath(root, file));
        jsonObject.put("size", file.getContentLength());
        jsonObject.put("lastModified", DateUtils.dateToString(new Date(file.getLastModified())));
        String mimeType = this._cocoonContext.getMimeType(file.getName().toLowerCase());
        jsonObject.put("mimetype", mimeType != null ? mimeType : "application/unknown");
        return jsonObject;
    }

    protected String _getRelativePath(TraversableSource root, TraversableSource file) {
        String relPath = file.getURI().substring(root.getURI().length());
        if (relPath.endsWith("/")) {
            relPath = relPath.substring(0, relPath.length() - 1);
        }
        return relPath;
    }
}

