/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.parameter.files;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.file.FileHelper;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.FileSource;

public class AddOrUpdateFile
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable {
    public static final String ROLE = AddOrUpdateFile.class.getName();
    protected Context _context;
    private SourceResolver _sResolver;
    private FileHelper _fileHelper;
    private CurrentUserProvider _currentUserProvider;
    private RightManager _rightManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._sResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._fileHelper = (FileHelper)((Object)smanager.lookup(FileHelper.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Callable(rights={""})
    public Map<String, Object> addOrUpdateFile(String filePath, String mode, Part part) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Request request = ContextHelper.getRequest((Context)this._context);
        FileSource paramsDir = (FileSource)this._sResolver.resolveURI("context://WEB-INF/param");
        FileSource parentDir = (FileSource)this._sResolver.resolveURI("context://WEB-INF/param" + (String)(filePath.length() > 0 ? "/" + filePath : ""));
        this._checkUserRight("CORE_Rights_EditParameterFile", "/${WorkspaceName}");
        result.putAll(this._fileHelper.addOrUpdateFile(part, parentDir, mode, false));
        if (result.containsKey("uri")) {
            String fileUrl = (String)result.get("uri");
            String path = fileUrl.substring(paramsDir.getURI().length());
            result.put("path", path.endsWith("/") ? path.substring(0, path.length() - 1) : path);
            String parentPath = parentDir.getURI().substring(paramsDir.getURI().length());
            result.put("parentPath", parentPath.endsWith("/") ? parentPath.substring(0, parentPath.length() - 1) : parentPath);
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return result;
    }

    protected void _checkUserRight(String rightId, String context) throws IllegalStateException {
        UserIdentity user = this._currentUserProvider.getUser();
        if (this._rightManager.hasRight(user, rightId, context) != RightManager.RightResult.RIGHT_ALLOW) {
            this.getLogger().error("User '" + String.valueOf(user) + "' tried to access a privileged feature without convenient right. Should have right '" + rightId + "' on context '" + context + "'");
            throw new IllegalStateException("You have no right to access this feature.");
        }
    }
}

