/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.parameter.files;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ametys.core.file.FileHelper;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.source.impl.FileSource;

public class ParametersClientSideElement
extends StaticClientSideElement
implements Component,
Initializable {
    private static final String _ROOT_PARAMETERS_DIRECTORY_URI = "context://WEB-INF/param";
    private FileHelper _fileHelper;
    private SourceResolver _srcResolver;
    private String _baseResolvedURI;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._fileHelper = (FileHelper)((Object)serviceManager.lookup(FileHelper.ROLE));
        this._srcResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
    }

    public void initialize() throws Exception {
        this._baseResolvedURI = this._srcResolver.resolveURI(_ROOT_PARAMETERS_DIRECTORY_URI).getURI();
    }

    @Callable(rights={"CORE_Rights_EditParameterFile"})
    public Map<String, Object> saveParameters(String relPath, String text) throws IOException {
        String fileURI = _ROOT_PARAMETERS_DIRECTORY_URI + (String)(relPath.length() > 0 ? "/" + relPath : "");
        return this._fileHelper.saveFile(fileURI, text);
    }

    @Callable(rights={"CORE_Rights_EditParameterFile"})
    public Map<String, Object> addFolder(String parentRelPath, String name) throws IOException {
        FileSource rootDir = (FileSource)this._srcResolver.resolveURI(_ROOT_PARAMETERS_DIRECTORY_URI);
        String parentURI = _ROOT_PARAMETERS_DIRECTORY_URI + (String)(parentRelPath.length() > 0 ? "/" + parentRelPath : "");
        Map<String, Object> result = this._fileHelper.addFolder(parentURI, name, true);
        if (result.containsKey("uri")) {
            String folderUri = (String)result.get("uri");
            String path = folderUri.substring(rootDir.getURI().length());
            result.put("path", path.endsWith("/") ? path.substring(0, path.length() - 1) : path);
            result.put("parentPath", parentRelPath.endsWith("/") ? parentRelPath.substring(0, parentRelPath.length() - 1) : parentRelPath);
        }
        return result;
    }

    @Callable(rights={"CORE_Rights_EditParameterFile"})
    public Map<String, Object> deleteFile(String relPath) throws IOException {
        String fileUri = _ROOT_PARAMETERS_DIRECTORY_URI + (String)(relPath.length() > 0 ? "/" + relPath : "");
        return this._fileHelper.deleteFile(fileUri);
    }

    @Callable(rights={"CORE_Rights_EditParameterFile"})
    public Map<String, Object> renameFile(String relPath, String name) throws IOException {
        FileSource rootDir = (FileSource)this._srcResolver.resolveURI(_ROOT_PARAMETERS_DIRECTORY_URI);
        String fileUri = _ROOT_PARAMETERS_DIRECTORY_URI + (String)(relPath.length() > 0 ? "/" + relPath : "");
        Map<String, Object> result = this._fileHelper.renameFile(fileUri, name);
        if (result.containsKey("uri")) {
            String newURI = (String)result.get("uri");
            String path = newURI.substring(rootDir.getURI().length());
            result.put("path", path);
        }
        return result;
    }

    @Callable(rights={"CORE_Rights_EditParameterFile"})
    public Map<String, Object> moveParameterFile(String srcRelPath, String parentRelPath) throws IOException {
        String targetPath;
        String srcPath = _ROOT_PARAMETERS_DIRECTORY_URI + (String)(srcRelPath.length() > 0 ? "/" + srcRelPath : "");
        Map<String, Object> result = this._fileHelper.moveSource(srcPath, targetPath = _ROOT_PARAMETERS_DIRECTORY_URI + (String)(parentRelPath.length() > 0 ? "/" + parentRelPath : ""));
        if (result.containsKey("uri")) {
            String newURI = (String)result.get("uri");
            String path = newURI.substring(_ROOT_PARAMETERS_DIRECTORY_URI.length() + 1);
            result.put("path", path);
        }
        return result;
    }

    @Callable(rights={"CORE_Rights_EditParameterFile"})
    public boolean fileExists(String parentRelPath, String name) throws Exception {
        String parentUri = _ROOT_PARAMETERS_DIRECTORY_URI + (String)(parentRelPath.length() > 0 ? "/" + parentRelPath : "");
        return this._fileHelper.hasChild(parentUri, name);
    }

    protected void _checkUserRight(String rightId, String context) throws IllegalStateException {
        UserIdentity user = this._currentUserProvider.getUser();
        if (this._rightManager.hasRight(user, rightId, context) != RightManager.RightResult.RIGHT_ALLOW) {
            this.getLogger().error("User '" + String.valueOf(user) + "' tried to access a privileged feature without convenient right. Should have right '" + rightId + "' on context '" + context + "'");
            throw new IllegalStateException("You have no right to access this feature.");
        }
    }

    @Callable(rights={"CORE_Rights_EditParameterFile"})
    public List<String> getFilteredPath(String value, String path) {
        try {
            TraversableSource currentSrc = (TraversableSource)this._srcResolver.resolveURI(_ROOT_PARAMETERS_DIRECTORY_URI + (String)(path.length() > 0 ? "/" + path : ""));
            return this._fileHelper.filterSources(currentSrc, value).stream().map(this::toRelativePath).toList();
        }
        catch (IOException e) {
            this.getLogger().error("Failed to filter source at path '" + path + "'", (Throwable)e);
            return List.of();
        }
    }

    private String toRelativePath(String absoluteURI) {
        String path = absoluteURI.substring(this._baseResolvedURI.length() - 1);
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

