/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.populations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.directory.ModifiableUserDirectory;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetUserPopulationsAction
extends ServiceableAction {
    private UserPopulationDAO _userPopulationDAO;
    private PopulationContextHelper _populationContextHelper;
    private CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userPopulationDAO = (UserPopulationDAO)serviceManager.lookup(UserPopulationDAO.ROLE);
        this._populationContextHelper = (PopulationContextHelper)serviceManager.lookup(PopulationContextHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        List<UserPopulation> populations;
        Map jsParameters = (Map)objectModel.get("parent-context");
        List contexts = (List)jsParameters.get("contexts");
        Boolean showDisabled = (Boolean)jsParameters.get("showDisabled");
        Boolean withAdmin = (Boolean)jsParameters.get("withAdmin");
        if (contexts == null && Boolean.TRUE.equals(showDisabled)) {
            populations = this._userPopulationDAO.getUserPopulations(Boolean.TRUE.equals(withAdmin));
        } else if (contexts == null) {
            populations = this._userPopulationDAO.getEnabledUserPopulations(Boolean.TRUE.equals(withAdmin));
        } else {
            Set<String> populationIds = this._populationContextHelper.getUserPopulationsOnContexts(contexts, false);
            populations = populationIds.stream().map(pId -> this._userPopulationDAO.getUserPopulation((String)pId)).collect(Collectors.toList());
        }
        Boolean modifiable = (Boolean)jsParameters.get("modifiable");
        Boolean userPopulationOnly = (Boolean)jsParameters.get("userPopulationOnly");
        List populationsAsJson = populations.stream().filter(up -> !Boolean.TRUE.equals(modifiable) || this.containsModifiableUserDirectory((UserPopulation)up)).filter(up -> !Boolean.TRUE.equals(userPopulationOnly) || up.getId().equals(this._currentUserProvider.getUser().getPopulationId())).map(this._userPopulationDAO::getUserPopulationAsJson).collect(Collectors.toList());
        HashMap result = new HashMap();
        result.put("userPopulations", populationsAsJson);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private boolean containsModifiableUserDirectory(UserPopulation up) {
        return up.getUserDirectories().stream().anyMatch(ud -> ud instanceof ModifiableUserDirectory);
    }
}

