/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ametys.core.resources.SimpleResourceHandler;
import org.apache.avalon.framework.component.Component;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;

public abstract class AbstractCompiledResourceHandler
extends SimpleResourceHandler
implements Component {
    private static Map<String, Pair<List<String>, Long>> _dependenciesCache = new ConcurrentHashMap<String, Pair<List<String>, Long>>();

    public AbstractCompiledResourceHandler(Source source) {
        super(source);
    }

    protected abstract List<String> getDependenciesList(Source var1);

    @Override
    public Serializable getKey() {
        return this._getDependenciesKeys(this._source, this._source.getURI(), FilenameUtils.normalize((String)this._source.getURI()), this._source.getLastModified(), new HashMap<String, String>());
    }

    @Override
    public SourceValidity getValidity() {
        Long lastModified = this._getCalculatedLastModified(this._source, this._source.getURI(), this._source.getLastModified(), new HashMap<String, String>());
        return lastModified != null ? new TimeStampValidity(lastModified.longValue()) : null;
    }

    @Override
    public long getLastModified() {
        Long lastModified = this._getCalculatedLastModified(this._source, this._source.getURI(), this._source.getLastModified(), new HashMap<String, String>());
        return lastModified != null ? lastModified.longValue() : super.getLastModified();
    }

    private Long _getCalculatedLastModified(Source inputSource, String sourceUri, long lastModified, HashMap<String, String> knowDependencies) {
        long result = lastModified;
        List<String> dependencies = this._getDependencies(inputSource, sourceUri, lastModified);
        for (String dependency : dependencies) {
            if (dependency == null || Strings.CS.startsWith((CharSequence)dependency, (CharSequence)"http://") || Strings.CS.startsWith((CharSequence)dependency, (CharSequence)"https://")) continue;
            try {
                HashMap params;
                String uriToResolve = this._getDependencyURI(sourceUri, dependency);
                Source dependencySource = this._resolver.resolveURI(uriToResolve, null, params = new HashMap());
                String fsURI = FilenameUtils.normalize((String)dependencySource.getURI());
                if (knowDependencies.containsKey(fsURI)) continue;
                knowDependencies.put(fsURI, sourceUri);
                Long calculatedLastModified = this._getCalculatedLastModified(dependencySource, uriToResolve, dependencySource.getLastModified(), knowDependencies);
                if (calculatedLastModified == null || calculatedLastModified <= result) continue;
                result = calculatedLastModified;
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to resolve the following uri : '" + dependency + "' while calculating dependencies for " + inputSource.getURI(), (Throwable)e);
                return null;
            }
        }
        return result;
    }

    private String _getDependenciesKeys(Source inputSource, String sourceUri, String fileURI, long lastModified, HashMap<String, String> knowDependencies) {
        Object result = fileURI;
        List<String> dependencies = this._getDependencies(inputSource, sourceUri, lastModified);
        for (String dependency : dependencies) {
            if (dependency == null || Strings.CS.startsWith((CharSequence)dependency, (CharSequence)"http://") || Strings.CS.startsWith((CharSequence)dependency, (CharSequence)"https://")) continue;
            try {
                String uriToResolve = this._getDependencyURI(sourceUri, dependency);
                HashMap params = new HashMap();
                Source dependencySource = this._resolver.resolveURI(uriToResolve, null, params);
                String fileDependencyURI = FilenameUtils.normalize((String)dependencySource.getURI());
                if (knowDependencies.containsKey(fileDependencyURI)) {
                    this.getLogger().warn("A loop import was detected in file : '" + sourceUri + "' that imports '" + fileDependencyURI + "' but it was already previously imported by '" + knowDependencies.get(fileDependencyURI) + "'.");
                    continue;
                }
                knowDependencies.put(fileDependencyURI, sourceUri);
                String dependenciesKeys = this._getDependenciesKeys(dependencySource, uriToResolve, fileDependencyURI, dependencySource.getLastModified(), knowDependencies);
                if (dependenciesKeys == null) continue;
                result = (String)result + "*" + dependenciesKeys;
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to resolve the following uri : '" + dependency + "' while calculating dependencies for " + inputSource.getURI(), (Throwable)e);
                return null;
            }
        }
        return result;
    }

    private String _getDependencyURI(String sourceUri, String dependency) throws URISyntaxException {
        URI uri = new URI(dependency);
        Object uriToResolve = uri.isAbsolute() ? dependency : FilenameUtils.getFullPath((String)sourceUri) + dependency;
        String schema = Strings.CS.contains((CharSequence)uriToResolve, (CharSequence)"://") ? ((String)uriToResolve).substring(0, ((String)uriToResolve).indexOf("://") + 3) : "";
        uriToResolve = schema + FilenameUtils.normalize((String)Strings.CS.removeStart((String)uriToResolve, (CharSequence)schema));
        return uriToResolve;
    }

    private List<String> _getDependencies(Source inputSource, String sourceUri, long lastModified) {
        List dependencies;
        Pair<List<String>, Long> cachedDependencies = _dependenciesCache.get(sourceUri);
        if (cachedDependencies == null || !((Long)cachedDependencies.getRight()).equals(lastModified)) {
            dependencies = this.getDependenciesList(inputSource);
            _dependenciesCache.put(sourceUri, (Pair<List<String>, Long>)Pair.of(dependencies, (Object)lastModified));
        } else {
            dependencies = (List)cachedDependencies.getLeft();
        }
        return dependencies;
    }
}

