/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURIExtensionPoint;
import org.apache.commons.io.FilenameUtils;

public final class CSSFileHelper {
    public static final Pattern IMPORT_PATTERN = Pattern.compile("(?<=^|\n|;)[ \t]*@import[ \t]*(?:url)?\\(?[ \t]*[\"']?([^)\"'\n]*)[\"']?\\)?[ \t]*([^; \t\r\n]*)[ \t]*(?:;|\n|$)?", 2);
    private static final Pattern CSS_URL_PATTERN_SRC = Pattern.compile("src\\s*=\\s*['\"](.*?)['\"]", 34);
    private static final Pattern CSS_URL_PATTERN_NOTIMPORT_URL = Pattern.compile("(?:@import\\s+url)|(?:\\burl\\s*\\(\\s*['\"]?(.*?)['\"]?\\s*\\))", 34);
    private static final Pattern CSS_URL_PATTERN_IMPORT_URL = Pattern.compile("@import\\s+url\\s*\\(\\s*['\"]?(.*?)['\"]?\\s*\\)", 34);
    private static final Pattern CSS_URL_PATTERN_IMPORT = Pattern.compile("@import\\s+['\"](.*?)['\"]", 34);

    private CSSFileHelper() {
    }

    public static String replaceRelativeUri(String content, String fileUri, JSASSResourceURIExtensionPoint jsassResourceURIExtensionPoint, String internalContextPath, String externalContextPath) throws URISyntaxException {
        String c1 = CSSFileHelper._replaceRelativeUri(content, externalContextPath, fileUri, CSS_URL_PATTERN_SRC, jsassResourceURIExtensionPoint);
        String c2 = CSSFileHelper._replaceRelativeUri(c1, externalContextPath, fileUri, CSS_URL_PATTERN_NOTIMPORT_URL, jsassResourceURIExtensionPoint);
        String c3 = CSSFileHelper._replaceRelativeUri(c2, internalContextPath, fileUri, CSS_URL_PATTERN_IMPORT_URL, jsassResourceURIExtensionPoint);
        String result = CSSFileHelper._replaceRelativeUri(c3, internalContextPath, fileUri, CSS_URL_PATTERN_IMPORT, jsassResourceURIExtensionPoint);
        return result;
    }

    public static String replaceRelativeResourcesUri(String content, String fileUri, JSASSResourceURIExtensionPoint jsassResourceURIExtensionPoint, String externalContextPath) throws URISyntaxException {
        String c1 = CSSFileHelper._replaceRelativeUri(content, externalContextPath, fileUri, CSS_URL_PATTERN_SRC, jsassResourceURIExtensionPoint);
        String result = CSSFileHelper._replaceRelativeUri(c1, externalContextPath, fileUri, CSS_URL_PATTERN_NOTIMPORT_URL, jsassResourceURIExtensionPoint);
        return result;
    }

    private static String _replaceRelativeUri(String content, String contextPath, String fileUri, Pattern pattern, JSASSResourceURIExtensionPoint jsassResourceURIExtensionPoint) {
        Matcher urlMatcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (urlMatcher.find()) {
            String fullMatch = urlMatcher.group();
            String cssUrl = urlMatcher.group(1);
            if (cssUrl == null || cssUrl.startsWith("data:")) continue;
            try {
                URI uri = new URI(cssUrl.replaceAll("\\|", "%7C"));
                if (!uri.isAbsolute() && cssUrl.indexOf("/") != 0 && cssUrl.indexOf("#") != 0) {
                    String fullFileUri = fileUri.indexOf(47) == 0 ? contextPath + fileUri : fileUri;
                    String fullPathUrl = new URI(FilenameUtils.getFullPath((String)fullFileUri) + cssUrl).normalize().toString();
                    urlMatcher.appendReplacement(sb, Matcher.quoteReplacement(fullMatch.replace(cssUrl, fullPathUrl)));
                    continue;
                }
                String relativeUri = jsassResourceURIExtensionPoint.resolve(cssUrl);
                if (relativeUri == null) continue;
                urlMatcher.appendReplacement(sb, Matcher.quoteReplacement(fullMatch.replace(cssUrl, relativeUri)));
            }
            catch (URISyntaxException e) {
                urlMatcher.appendTail(sb);
                return sb.toString();
            }
        }
        urlMatcher.appendTail(sb);
        return sb.toString();
    }
}

