/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css;

import java.io.IOException;
import org.ametys.core.resources.AbstractResourceHandlerProvider;
import org.ametys.core.resources.CssResourceHandler;
import org.ametys.core.resources.ResourceHandler;
import org.ametys.plugins.core.ui.resources.css.less.LessResourceHandler;
import org.ametys.plugins.core.ui.resources.css.sass.SassResourceHandler;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class CompiledCssResourceHandlerProvider
extends AbstractResourceHandlerProvider {
    private static final String[] __LESS_EXTENSION = new String[]{".less"};
    private static final String[] __SASS_EXTENSION = new String[]{".scss", ".sass"};
    private SourceResolver _resolver;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    public ResourceHandler getResourceHandler(String source) throws Exception {
        String lcSource = StringUtils.lowerCase((String)source);
        if (!Strings.CS.endsWith((CharSequence)lcSource, (CharSequence)".css")) {
            return null;
        }
        Source src = this._resolver.resolveURI(source);
        if (src.exists()) {
            return this.setup(new CssResourceHandler(src));
        }
        this._resolver.release(src);
        String sourceWithoutExt = StringUtils.substringBeforeLast((String)source, (String)".css");
        ResourceHandler handler = this._getSassResourceHandler(sourceWithoutExt);
        if (handler != null) {
            return handler;
        }
        handler = this._getLessResourceHandler(sourceWithoutExt);
        if (handler != null) {
            return handler;
        }
        return null;
    }

    private ResourceHandler _getLessResourceHandler(String sourceWithoutExt) throws Exception {
        for (String ext : __LESS_EXTENSION) {
            try {
                Source src = this._resolver.resolveURI(sourceWithoutExt + ext);
                if (src.exists()) {
                    return this.setup(new LessResourceHandler(src));
                }
                this._resolver.release(src);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private ResourceHandler _getSassResourceHandler(String sourceWithoutExt) throws Exception {
        for (String ext : __SASS_EXTENSION) {
            Source src = null;
            try {
                String sassLocation = Strings.CS.removeEnd(sourceWithoutExt, (CharSequence)".min") + ext;
                src = this._resolver.resolveURI(sassLocation);
                if (src.exists()) {
                    return this.setup(new SassResourceHandler(src, sassLocation));
                }
                this._resolver.release(src);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

