/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css;

import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURI;

public class WorkspacesJSASSResourceURI
implements JSASSResourceURI {
    private static final Pattern URI_SUPPORTED_PATTERN = Pattern.compile("^workspace:([^:]+)://(.*)$");
    private static final Pattern PATH_SUPPORTED_PATTERN = Pattern.compile("^/_([^/]+)/(.*)$");

    @Override
    public String resolve(String uri) throws URISyntaxException {
        Matcher matcher = URI_SUPPORTED_PATTERN.matcher(uri);
        if (matcher.matches()) {
            String target = matcher.group(1);
            String path = matcher.group(2);
            StringBuilder relativeSb = new StringBuilder();
            relativeSb.append("/_");
            relativeSb.append(target);
            relativeSb.append("/");
            relativeSb.append(path);
            return relativeSb.toString();
        }
        return null;
    }

    @Override
    public String resolvePath(String path) {
        Matcher matcher = PATH_SUPPORTED_PATTERN.matcher(path);
        if (matcher.matches()) {
            StringBuilder uri = new StringBuilder();
            uri.append("workspace:");
            uri.append(matcher.group(1));
            uri.append("://");
            uri.append(matcher.group(2));
            return uri.toString();
        }
        return null;
    }
}

