/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css.less;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.ametys.plugins.core.ui.resources.AbstractCompiledResourceHandler;
import org.ametys.plugins.core.ui.resources.css.CSSFileHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Strings;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class LessResourceHandler
extends AbstractCompiledResourceHandler {
    private DefaultLessCompiler _defaultLessCompiler;

    public LessResourceHandler(Source source) {
        super(source);
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters par, boolean readForDownload) throws ProcessingException, IOException {
        Source source = super.setup(location, objectModel, par, readForDownload);
        this._defaultLessCompiler = new DefaultLessCompiler();
        return source;
    }

    @Override
    public void generate(OutputStream out) throws IOException, ProcessingException {
        LessCompiler.CompilationResult result = null;
        try (InputStream is = this._source.getInputStream();){
            String lessContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            AmetysLessSource stringSource = new AmetysLessSource(this._resolver, lessContent, new URI(this._source.getURI()));
            result = this._defaultLessCompiler.compile((LessSource)stringSource);
        }
        catch (Less4jException e) {
            throw new ProcessingException("Unable to compile the LESS file : " + this._source.getURI(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ProcessingException("Unable to process LESS File, invalid uri : " + this._source.getURI(), (Throwable)e);
        }
        String resultString = result == null ? null : result.getCss();
        IOUtils.write((String)resultString, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
    }

    @Override
    protected List<String> getDependenciesList(Source inputSource) {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream is = inputSource.getInputStream();){
            String content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            Matcher matcher = CSSFileHelper.IMPORT_PATTERN.matcher(content);
            while (matcher.find()) {
                Object cssUrl = matcher.group(1);
                if (Strings.CS.contains((CharSequence)cssUrl, (CharSequence)"http://") || Strings.CS.contains((CharSequence)cssUrl, (CharSequence)"https://")) continue;
                if (!Strings.CS.endsWith((CharSequence)cssUrl, (CharSequence)".css") && !Strings.CS.endsWith((CharSequence)cssUrl, (CharSequence)".less")) {
                    cssUrl = (String)cssUrl + ".less";
                }
                result.add((String)cssUrl);
            }
        }
        catch (IOException e) {
            this.getLogger().warn("Invalid content when listing dependencies for file " + inputSource.getURI(), (Throwable)e);
        }
        return result;
    }

    @Override
    public String getMimeType() {
        return "text/css";
    }

    private static class AmetysLessSource
    extends LessSource {
        private String _lessContent;
        private String _name;
        private URI _sourceUri;
        private SourceResolver _sResolver;

        public AmetysLessSource(SourceResolver sourceResolver, String lessContent, URI uri) {
            this._sResolver = sourceResolver;
            this._lessContent = lessContent;
            this._sourceUri = uri;
        }

        public LessSource relativeSource(String relativePath) throws LessSource.FileNotFound, LessSource.CannotReadFile, LessSource.StringSourceException {
            AmetysLessSource ametysLessSource;
            Source importSource = null;
            try {
                URI relativeSourceUri = new URI(relativePath);
                if (!relativeSourceUri.isAbsolute()) {
                    relativeSourceUri = new URI(FilenameUtils.getFullPath((String)this._sourceUri.toString()) + relativePath);
                }
                importSource = this._sResolver.resolveURI(relativeSourceUri.toString());
                String importText = IOUtils.toString((InputStream)importSource.getInputStream(), (String)"UTF-8");
                ametysLessSource = new AmetysLessSource(this._sResolver, importText, relativeSourceUri);
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Unable to process LESS File : " + String.valueOf(this._sourceUri) + ", invalid import : " + relativePath, e);
                }
                catch (Throwable throwable) {
                    this._sResolver.release(importSource);
                    throw throwable;
                }
            }
            this._sResolver.release(importSource);
            return ametysLessSource;
        }

        public String getContent() throws LessSource.FileNotFound, LessSource.CannotReadFile {
            return this._lessContent;
        }

        public byte[] getBytes() throws LessSource.FileNotFound, LessSource.CannotReadFile {
            try {
                return this._lessContent.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new LessSource.CannotReadFile();
            }
        }

        public URI getURI() {
            return this._sourceUri;
        }

        public String getName() {
            return this._name;
        }
    }
}

