/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css.sass;

import io.bit3.jsass.CompilationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ametys.core.minimize.css.sass.MinimizeSassManager;
import org.ametys.core.resources.ProxiedContextPathProvider;
import org.ametys.plugins.core.ui.resources.AbstractCompiledResourceHandler;
import org.ametys.plugins.core.ui.resources.css.sass.SassImportHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Strings;
import org.apache.excalibur.source.Source;

public class SassResourceHandler
extends AbstractCompiledResourceHandler {
    protected MinimizeSassManager _sassMinimizeManager;
    protected SassImportHelper _sassImportHelper;
    protected ProxiedContextPathProvider _proxiedContextPathProvider;
    private boolean _minimize;
    private String _sassLocation;

    public SassResourceHandler(Source source, String sassLocation) {
        super(source);
        this._sassLocation = sassLocation;
    }

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._sassMinimizeManager = (MinimizeSassManager)manager.lookup(MinimizeSassManager.ROLE);
        this._sassImportHelper = (SassImportHelper)manager.lookup(SassImportHelper.ROLE);
        this._proxiedContextPathProvider = (ProxiedContextPathProvider)manager.lookup(ProxiedContextPathProvider.ROLE);
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters par, boolean readForDownload) throws ProcessingException, IOException {
        Source source = super.setup(location, objectModel, par, readForDownload);
        this._minimize = Strings.CS.endsWith((CharSequence)location, (CharSequence)".min.css");
        return source;
    }

    @Override
    public void generate(OutputStream out) throws IOException, ProcessingException {
        try (InputStream is = this._source.getInputStream();){
            String sassContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            String result = this._sassMinimizeManager.compileCss(sassContent, this._sassLocation, this._requestedLocation, this._minimize, this._source.getLastModified());
            IOUtils.write((String)result, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
        }
        catch (CompilationException | URISyntaxException e) {
            throw new ProcessingException("Unable to compile the SASS file: " + this._source.getURI(), e);
        }
    }

    @Override
    protected List<String> getDependenciesList(Source inputSource) {
        return new ArrayList<String>(this._sassImportHelper.getDependenciesList(inputSource).keySet());
    }

    @Override
    public Serializable getKey() {
        return String.valueOf(super.getKey()) + "*" + (this._minimize ? "min" : "") + "*" + this._proxiedContextPathProvider.getContextPath();
    }

    @Override
    public String getMimeType() {
        return "text/css";
    }
}

