/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css.sass;

import io.bit3.jsass.CompilationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.ametys.core.minimize.SourceMapCache;
import org.ametys.core.minimize.css.sass.MinimizeSassManager;
import org.ametys.core.resources.ProxiedContextPathProvider;
import org.ametys.core.resources.SimpleResourceHandler;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURIExtensionPoint;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Strings;
import org.apache.excalibur.source.Source;

public class SassSourceMapResourceHandler
extends SimpleResourceHandler
implements Contextualizable {
    protected MinimizeSassManager _sassMinimizeManager;
    private boolean _minimize;
    private String _sourceMapLocation;
    private SourceMapCache _sourceMapCache;
    private JSASSResourceURIExtensionPoint _jsassResourceURIExtensionPoint;
    private ProxiedContextPathProvider _proxiedContextPathProvider;
    private Context _context;

    public SassSourceMapResourceHandler() {
    }

    public SassSourceMapResourceHandler(Source source) {
        super(source);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._sourceMapCache = (SourceMapCache)manager.lookup(SourceMapCache.ROLE);
        this._sassMinimizeManager = (MinimizeSassManager)manager.lookup(MinimizeSassManager.ROLE);
        this._jsassResourceURIExtensionPoint = (JSASSResourceURIExtensionPoint)manager.lookup(JSASSResourceURIExtensionPoint.ROLE);
        this._proxiedContextPathProvider = (ProxiedContextPathProvider)manager.lookup(ProxiedContextPathProvider.ROLE);
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters parameters, boolean readForDownload) throws IOException, ProcessingException {
        this._sourceMapLocation = location;
        String originalSassLocation = Strings.CS.removeEnd(location, (CharSequence)".map");
        return super.setup(originalSassLocation, objectModel, parameters, readForDownload);
    }

    @Override
    public Serializable getKey() {
        return String.valueOf(super.getKey()) + ".map" + (this._minimize ? "*min" : "");
    }

    @Override
    public void generate(OutputStream out) throws IOException, ProcessingException {
        InputStream is;
        Source cachedSourceMap = null;
        try {
            String sourceMapCacheKey = this._jsassResourceURIExtensionPoint.resolve(this._sourceMapLocation);
            cachedSourceMap = this._sourceMapCache.get(sourceMapCacheKey);
        }
        catch (URISyntaxException e) {
            this.getLogger().error("Unable to resolve URI location because URI syntax '" + this._sourceMapLocation + "' is not supported", (Throwable)e);
        }
        if (cachedSourceMap != null) {
            is = cachedSourceMap.getInputStream();
            try {
                IOUtils.copy((InputStream)is, (OutputStream)out);
                return;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        try {
            is = this._source.getInputStream();
            try {
                String sassContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                String extension = FilenameUtils.getExtension((String)this._source.getURI());
                String sourceMap = this._sassMinimizeManager.generateCssSourceMap(sassContent, this._sourceMapLocation, extension, ContextHelper.getRequest((Context)this._context).getContextPath(), this._proxiedContextPathProvider.getContextPath(), this._minimize, this._source.getLastModified());
                IOUtils.write((String)sourceMap, (OutputStream)out, (String)"UTF-8");
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (CompilationException | URISyntaxException e) {
            throw new ProcessingException("Unable to compile the SASS file: " + this._source.getURI(), e);
        }
    }
}

