/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css.sass;

import java.io.IOException;
import org.ametys.core.resources.AbstractResourceHandlerProvider;
import org.ametys.core.resources.ResourceHandler;
import org.ametys.plugins.core.ui.resources.css.sass.SassSourceMapResourceHandler;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class SassSourceMapResourceHandlerProvider
extends AbstractResourceHandlerProvider {
    private static final String[] __SASS_EXTENSION = new String[]{".scss", ".sass"};
    private SourceResolver _resolver;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    public ResourceHandler getResourceHandler(String source) throws Exception {
        String lcSource = StringUtils.lowerCase((String)source);
        for (String ext : __SASS_EXTENSION) {
            if (!Strings.CS.endsWith((CharSequence)lcSource, (CharSequence)(ext + ".map"))) continue;
            return this.setup(new SassSourceMapResourceHandler());
        }
        if (lcSource.endsWith(".css.map")) {
            String sourceWithoutExt = StringUtils.substringBeforeLast((String)source, (String)".css.map");
            for (String ext : __SASS_EXTENSION) {
                Source src = null;
                try {
                    src = this._resolver.resolveURI(sourceWithoutExt + ext);
                    if (src.exists()) {
                        return this.setup(new SassSourceMapResourceHandler(src));
                    }
                    this._resolver.release(src);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

