/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.vuejs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.resources.ProxiedContextPathProvider;
import org.ametys.plugins.core.ui.resources.AbstractCompiledResourceHandler;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.source.impl.FileSource;

public class VueJsResourceHandler
extends AbstractCompiledResourceHandler
implements Contextualizable {
    private static final Pattern SOURCEMAP_SOURCES_PATTERN = Pattern.compile("^(.*\"sources\":\\[)(.*?)(\\].*)$");
    private static final Pattern SOURCEMAP_SOURCE_PATTERN = Pattern.compile("\"([^\"]*)\"");
    private Context _context;
    private LocationParser _lp;
    private ProxiedContextPathProvider _proxiedContextPathProvider;

    public VueJsResourceHandler(Source source) {
        super(source);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._proxiedContextPathProvider = (ProxiedContextPathProvider)manager.lookup(ProxiedContextPathProvider.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source setup(String location, Map objectModel, Parameters parameters, boolean readForDownload) throws IOException, ProcessingException {
        Source binaryResource;
        this._requestedLocation = location;
        this._objectModel = objectModel;
        this._parameters = parameters;
        this._readForDownload = readForDownload;
        this._lp = new LocationParser(location);
        if (!this._lp.matches()) {
            throw new IOException("Path does not match: " + location);
        }
        Source vueSourceFileSource = this._handleSourcesFiles();
        if (vueSourceFileSource != null) {
            this._source = vueSourceFileSource;
            return vueSourceFileSource;
        }
        Source componentSource = this._resolver.resolveURI(this._lp.getComponentLocation());
        Source binarySource = this._resolver.resolveURI(this._lp.getBinaryLocation());
        VueJsResourceHandler vueJsResourceHandler = this;
        synchronized (vueJsResourceHandler) {
            if (!binarySource.exists() || binarySource.getLastModified() < this._getLastModified(componentSource)) {
                Source packageJsonSource = this._resolver.resolveURI(this._lp.getPackageJSONLocation());
                if (!binarySource.exists() || binarySource.getLastModified() < this._getLastModified(packageJsonSource)) {
                    try {
                        File commonDir = ((FileSource)this._resolver.resolveURI(this._lp.getCommonLocation())).getFile();
                        this._installDependencies(commonDir);
                        File sourceDir = ((FileSource)this._resolver.resolveURI(this._lp.getComponentLocation())).getFile();
                        this._installDependencies(sourceDir);
                    }
                    catch (ProcessingException e) {
                        throw new IOException("Error while retrieving dependencies: " + location, e);
                    }
                }
                try {
                    this._compile(binarySource);
                }
                catch (ProcessingException e) {
                    throw new IOException("Compilation error with module: " + location, e);
                }
            }
        }
        this._source = binaryResource = this._resolver.resolveURI(this._lp.getBinaryLocation() + this._lp.getVuejsFile());
        return binaryResource;
    }

    private Source _handleSourcesFiles() throws MalformedURLException, IOException {
        if (!(Strings.CS.endsWith((CharSequence)this._lp.getVuejsFile(), (CharSequence)".vue") || Strings.CS.endsWith((CharSequence)this._lp.getVuejsFile(), (CharSequence)".js") && !Strings.CS.equals(this._lp.getVuejsFile(), "/main.umd.min.js"))) {
            return null;
        }
        Response response = ContextHelper.getResponse((Context)this._context);
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setDateHeader("Expires", 0L);
        String file = this._lp.getVuejsFile();
        file = file.substring(file.indexOf(47, 1));
        String root = this._lp.getSourceLocation();
        if (Strings.CS.equals(this._lp.getComponent(), "/_common")) {
            root = Strings.CS.removeEnd(root, (CharSequence)"/src");
        }
        Source originalResource = this._resolver.resolveURI(root + file);
        return originalResource;
    }

    private void _executeCommandeLine(String[] command, File directory, String successLog, String errorKeyword, String errorLog) throws IOException, ProcessingException {
        Object[] objectArray;
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            String[] stringArray = new String[2];
            stringArray[0] = "cmd";
            objectArray = stringArray;
            stringArray[1] = "/c";
        } else {
            objectArray = new String[]{};
        }
        Object[] cmdPrefix = objectArray;
        Process process = Runtime.getRuntime().exec((String[])ArrayUtils.addAll((Object[])cmdPrefix, (Object[])command), null, directory);
        ArrayList<String> out = new ArrayList<String>();
        ReadStream inputStreamReader = new ReadStream(this, process.getInputStream(), out);
        ReadStream errorStreamReader = new ReadStream(this, process.getErrorStream(), out);
        Thread inputThread = new Thread(inputStreamReader);
        Thread errorThread = new Thread(errorStreamReader);
        inputThread.start();
        errorThread.start();
        try {
            int exitCode = process.waitFor();
            String outAsString = StringUtils.join(out, (char)'\n');
            if (exitCode != 0 || outAsString.contains(errorKeyword)) {
                throw new ProcessingException(errorLog + "\n" + outAsString);
            }
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info(successLog + "\n" + outAsString);
            }
        }
        catch (InterruptedException e) {
            throw new ProcessingException((Exception)e);
        }
    }

    private void _compile(Source binarySource) throws IOException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Compiling " + this._lp.getSourceLocation());
        }
        File sourceDir = ((FileSource)this._resolver.resolveURI(this._lp.getSourceLocation())).getFile();
        File outputDir = ((FileSource)binarySource).getFile();
        outputDir.delete();
        this._executeCommandeLine(new String[]{"yarn", "build", "--outDir", outputDir.getAbsolutePath()}, sourceDir, "Compilation of " + this._lp.getSourceLocation() + " ended with", "Build failed", "Could not compile " + this._lp.getSourceLocation() + " due to:");
    }

    private void _installDependencies(File sourceDir) throws IOException, ProcessingException {
        if (!sourceDir.exists()) {
            return;
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Getting dependencies of " + sourceDir.getAbsolutePath());
        }
        this._executeCommandeLine(new String[]{"yarn"}, sourceDir, "Installing dependencies of " + this._lp.getComponentLocation() + " ended with:", "Failed with errors", "Could not get dependencies " + this._lp.getComponentLocation() + " due to:");
    }

    @Override
    public void generate(OutputStream out) throws IOException, ProcessingException {
        if (this._source.getURI().endsWith(".map")) {
            Request request = ObjectModelHelper.getRequest((Map)this._objectModel);
            String currentURI = request.getSitemapURI();
            String currentPrefix = StringUtils.substringBefore((String)currentURI, (String)"/vuejs");
            String sourceUri = currentURI.substring(0, currentURI.lastIndexOf(46));
            String ext = sourceUri.substring(sourceUri.lastIndexOf(46) + 1);
            String componentPrefix = this._proxiedContextPathProvider.getContextPath() + "/" + currentPrefix + "/vuejs" + this._lp.getComponent() + "/" + ext;
            String commonPrefix = this._proxiedContextPathProvider.getContextPath() + "/" + currentPrefix + "/vuejs/_common/" + ext;
            try (InputStream is = this._source.getInputStream();){
                String mapContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                String mapContentFixed = this._fixSourceMap(mapContent, componentPrefix, commonPrefix);
                IOUtils.write((String)mapContentFixed, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
            }
        } else {
            super.generate(out);
        }
    }

    private String _fixSourceMap(String sourceMap, String componentPrefix, String commonPrefix) {
        Matcher matcher = SOURCEMAP_SOURCES_PATTERN.matcher(sourceMap);
        if (matcher.matches()) {
            StringBuilder result = new StringBuilder();
            result.append(matcher.group(1));
            String sources = matcher.group(2);
            Matcher sourceMatcher = SOURCEMAP_SOURCE_PATTERN.matcher(sources);
            while (sourceMatcher.find()) {
                String source = sourceMatcher.group(1);
                if (source.contains(".yarn") || source.contains("node_modules")) {
                    sourceMatcher.appendReplacement(result, "null");
                    continue;
                }
                if (source.startsWith("../src/")) {
                    sourceMatcher.appendReplacement(result, "\"" + componentPrefix + source.substring(6) + "\"");
                    continue;
                }
                if (!source.startsWith("../../_common/")) continue;
                sourceMatcher.appendReplacement(result, "\"" + commonPrefix + source.substring(13) + "\"");
            }
            sourceMatcher.appendTail(result);
            result.append(matcher.group(3));
            return result.toString();
        }
        return sourceMap;
    }

    @Override
    public long getLastModified() {
        return this._getLastModified(this._source);
    }

    private long _getLastModified(Source inputSource) {
        long result = inputSource.getLastModified();
        if (this._isSourceDirectory(inputSource)) {
            TraversableSource folder = (TraversableSource)inputSource;
            try {
                Collection children = folder.getChildren();
                for (Source child : children) {
                    result = Math.max(result, this._getLastModified(child));
                }
            }
            catch (SourceException e) {
                this.getLogger().warn("Cannot get dependencies files of source " + inputSource.getURI(), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    protected List<String> getDependenciesList(Source inputSource) {
        ArrayList<String> dependencies = new ArrayList<String>();
        if (this._isSourceDirectory(inputSource)) {
            TraversableSource folder = (TraversableSource)inputSource;
            try {
                Collection children = folder.getChildren();
                for (Source child : children) {
                    dependencies.add(child.getURI());
                }
            }
            catch (SourceException e) {
                this.getLogger().warn("Cannot get dependencies files of source " + inputSource.getURI(), (Throwable)e);
            }
        }
        return dependencies;
    }

    private boolean _isSourceDirectory(Source inputSource) {
        return inputSource instanceof TraversableSource && ((TraversableSource)inputSource).isCollection() && !inputSource.getURI().endsWith("/node_modules/") && !inputSource.getURI().endsWith("/dist/");
    }

    static final class LocationParser {
        private static final Pattern __LOCATION = Pattern.compile("^(.*)(/[^/]*)(/vuejs)(/[^/]*)(/.*)$");
        private static final String __OUTPUT_DIR = "/dist";
        private static final String __SOURCE_DIR = "/src";
        private static final String __PACKAGE_JSON_FILE = File.separator + "package.json";
        private String _location;
        private String _mainLocation;
        private String _parentFolder;
        private String _vuejsDirectoryName;
        private String _vuejsComponentName;
        private String _vuejsFile;

        LocationParser(String location) {
            this._location = location;
            Matcher matcher = __LOCATION.matcher(location);
            if (matcher.matches()) {
                this._mainLocation = matcher.group(1);
                this._parentFolder = matcher.group(2);
                this._vuejsDirectoryName = matcher.group(3);
                this._vuejsComponentName = matcher.group(4);
                this._vuejsFile = matcher.group(5);
            }
        }

        boolean matches() {
            return this._mainLocation != null;
        }

        String getLocation() {
            return this._location;
        }

        String getParentFolder() {
            return this._parentFolder;
        }

        String getComponent() {
            return this._vuejsComponentName;
        }

        String getCommonLocation() {
            return this._mainLocation + this._vuejsDirectoryName + "/_common";
        }

        String getComponentLocation() {
            return this._mainLocation + this._vuejsDirectoryName + this._vuejsComponentName;
        }

        String getPackageJSONLocation() {
            return this.getComponentLocation() + __PACKAGE_JSON_FILE;
        }

        String getVuejsFile() {
            return this._vuejsFile;
        }

        String getBinaryLocation() {
            return this._mainLocation + this._vuejsDirectoryName + this._vuejsComponentName + __OUTPUT_DIR;
        }

        String getSourceLocation() {
            return this._mainLocation + this._vuejsDirectoryName + this._vuejsComponentName + __SOURCE_DIR;
        }
    }

    class ReadStream
    implements Runnable {
        private final InputStream _inputStream;
        private final List<String> _sf;
        private boolean _isEmpty;

        ReadStream(VueJsResourceHandler this$0, InputStream inputStream, List<String> sf) {
            this._inputStream = inputStream;
            this._sf = sf;
            this._isEmpty = true;
        }

        private BufferedReader getBufferedReader(InputStream is) {
            return new BufferedReader(new InputStreamReader(is));
        }

        @Override
        public void run() {
            BufferedReader br = this.getBufferedReader(this._inputStream);
            String line = "";
            try {
                while ((line = br.readLine()) != null) {
                    this._sf.add(line);
                    this._isEmpty = false;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        boolean isEmpty() {
            return this._isEmpty;
        }
    }
}

