/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.right.profile;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessControllerExtensionPoint;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.ProfileBasedAccessController;
import org.ametys.core.right.RightContextConvertorExtensionPoint;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.ui.right.ProfileAssignmentsToolClientSideElement;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.UserPopulationDAO;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ProfilesUsesToolClientSideElement
extends StaticClientSideElement {
    protected AccessControllerExtensionPoint _accessControllerEP;
    protected GroupDirectoryDAO _groupDirectoryDAO;
    protected GroupManager _groupManager;
    protected UserPopulationDAO _populationDAO;
    protected RightContextConvertorExtensionPoint _rightContextConvertorEP;
    protected UserManager _userManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._accessControllerEP = (AccessControllerExtensionPoint)manager.lookup(AccessControllerExtensionPoint.ROLE);
        this._groupDirectoryDAO = (GroupDirectoryDAO)manager.lookup(GroupDirectoryDAO.ROLE);
        this._groupManager = (GroupManager)manager.lookup(GroupManager.ROLE);
        this._populationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._rightContextConvertorEP = (RightContextConvertorExtensionPoint)manager.lookup(RightContextConvertorExtensionPoint.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
    }

    @Callable(rights={"Runtime_Rights_Profiles_Uses"})
    public List<Map<String, Object>> getProfileUses(String profileId) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ProfileUses uses = this.explainAllProfileUses(profileId);
        Stream.of(uses.usesForAnonymous().keySet().stream(), uses.usesForAnyConnected().keySet().stream(), uses.usesByGroups().keySet().stream(), uses.usesByUser().keySet().stream()).flatMap(Function.identity()).distinct().forEach(object -> {
            List<Map<String, Object>> jsonPermissions = this._usesToJSONPermissions(uses, (AccessController.ExplanationObject)object);
            if (!jsonPermissions.isEmpty()) {
                HashMap<String, Object> contextResult = new HashMap<String, Object>();
                contextResult.put("label", object.label());
                contextResult.put("category", object.category());
                contextResult.put("order", object.order());
                contextResult.put("permissions", jsonPermissions);
                result.add(contextResult);
            }
        });
        return result;
    }

    protected ProfileUses explainAllProfileUses(String profileId) {
        Set<Object> workspacesContexts = this._rightContextConvertorEP.getConvertedObjects("/${WorkspaceName}");
        HashMap<AccessController.ExplanationObject, List<AccessExplanation>> usesForAnonymous = new HashMap<AccessController.ExplanationObject, List<AccessExplanation>>();
        HashMap<AccessController.ExplanationObject, List<AccessExplanation>> usesForAnyConnected = new HashMap<AccessController.ExplanationObject, List<AccessExplanation>>();
        HashMap<AccessController.ExplanationObject, Map<GroupIdentity, List<AccessExplanation>>> usesByGroups = new HashMap<AccessController.ExplanationObject, Map<GroupIdentity, List<AccessExplanation>>>();
        HashMap<AccessController.ExplanationObject, Map<UserIdentity, List<AccessExplanation>>> usesByUser = new HashMap<AccessController.ExplanationObject, Map<UserIdentity, List<AccessExplanation>>>();
        for (String controllerId : this._accessControllerEP.getExtensionsIds()) {
            AccessController accessController = (AccessController)this._accessControllerEP.getExtension(controllerId);
            if (!(accessController instanceof ProfileBasedAccessController)) continue;
            ProfileBasedAccessController controller = (ProfileBasedAccessController)accessController;
            try {
                Object entry32;
                Map<AccessController.ExplanationObject, AccessExplanation> anonymous = controller.explainAllProfileUsesForAnonymousOnWorkspaces(profileId, workspacesContexts);
                for (Map.Entry<AccessController.ExplanationObject, AccessExplanation> entry : anonymous.entrySet()) {
                    List anonymousExplanation = usesForAnonymous.computeIfAbsent(entry.getKey(), k -> new ArrayList());
                    anonymousExplanation.add(entry.getValue());
                }
                Map<AccessController.ExplanationObject, AccessExplanation> anyConnected = controller.explainAllProfileUsesForAnyConnectedOnWorkspaces(profileId, workspacesContexts);
                for (Object entry32 : anyConnected.entrySet()) {
                    List list = usesForAnyConnected.computeIfAbsent(entry32.getKey(), k -> new ArrayList());
                    list.add((AccessExplanation)entry32.getValue());
                }
                Map<AccessController.ExplanationObject, Map<GroupIdentity, AccessExplanation>> map = controller.explainAllProfileUsesOnWorkspacesByGroups(profileId, workspacesContexts);
                entry32 = map.entrySet().iterator();
                while (entry32.hasNext()) {
                    Map.Entry entry = (Map.Entry)entry32.next();
                    Map groupsExplanation = usesByGroups.computeIfAbsent((AccessController.ExplanationObject)entry.getKey(), k -> new HashMap());
                    for (Map.Entry groupEntry : ((Map)entry.getValue()).entrySet()) {
                        List groupExplanation = groupsExplanation.computeIfAbsent((GroupIdentity)groupEntry.getKey(), k -> new ArrayList());
                        groupExplanation.add((AccessExplanation)groupEntry.getValue());
                    }
                }
                Map<AccessController.ExplanationObject, Map<UserIdentity, AccessExplanation>> users = controller.explainAllProfileUsesOnWorkspacesByUser(profileId, workspacesContexts);
                for (Map.Entry<AccessController.ExplanationObject, Map<UserIdentity, AccessExplanation>> entry5 : users.entrySet()) {
                    Map usersExplanation = usesByUser.computeIfAbsent(entry5.getKey(), k -> new HashMap());
                    for (Map.Entry<UserIdentity, AccessExplanation> userEntry : entry5.getValue().entrySet()) {
                        List userExplanation = usersExplanation.computeIfAbsent(userEntry.getKey(), k -> new ArrayList());
                        userExplanation.add(userEntry.getValue());
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().error("An error occured while retrieving the permission for the controller '" + controllerId + "'. The controller will be ignored.", (Throwable)e);
            }
        }
        return new ProfileUses(usesForAnonymous, usesForAnyConnected, usesByGroups, usesByUser);
    }

    private List<Map<String, Object>> _usesToJSONPermissions(ProfileUses uses, AccessController.ExplanationObject object) {
        List list;
        List anonymous;
        Map<UserIdentity, List<AccessExplanation>> users;
        ArrayList<Map<String, Object>> json = new ArrayList<Map<String, Object>>();
        Map<GroupIdentity, List<AccessExplanation>> groups = uses.usesByGroups().get(object);
        if (groups != null) {
            for (Map.Entry<GroupIdentity, List<AccessExplanation>> groupEntry : groups.entrySet()) {
                Group group = this._groupManager.getGroup((GroupIdentity)groupEntry.getKey());
                if (group == null) continue;
                List groupExplanations = (List)groupEntry.getValue();
                groupExplanations.sort(Comparator.naturalOrder());
                HashMap<String, Object> groupPermissions = new HashMap<String, Object>();
                groupPermissions.put("targetType", ProfileAssignmentsToolClientSideElement.TargetType.GROUP.toString());
                String groupId = ((GroupIdentity)groupEntry.getKey()).getId();
                String directoryId = ((GroupIdentity)groupEntry.getKey()).getDirectoryId();
                groupPermissions.put("groupId", groupId);
                groupPermissions.put("groupLabel", group.getLabel());
                groupPermissions.put("groupDirectory", directoryId);
                groupPermissions.put("groupDirectoryLabel", this._groupDirectoryDAO.getGroupDirectory(directoryId).getLabel());
                groupPermissions.put("result", Map.of("accessResult", ((AccessExplanation)groupExplanations.get(0)).accessResult(), "accessExplanations", groupExplanations));
                json.add(groupPermissions);
            }
        }
        if ((users = uses.usesByUser().get(object)) != null) {
            for (Map.Entry entry : users.entrySet()) {
                User user = this._userManager.getUser((UserIdentity)entry.getKey());
                if (user == null) continue;
                List userExplanations = (List)entry.getValue();
                userExplanations.sort(Comparator.naturalOrder());
                HashMap<String, Object> userPermissions = new HashMap<String, Object>();
                userPermissions.put("targetType", ProfileAssignmentsToolClientSideElement.TargetType.USER.toString());
                userPermissions.put("login", ((UserIdentity)entry.getKey()).getLogin());
                userPermissions.put("populationId", ((UserIdentity)entry.getKey()).getPopulationId());
                userPermissions.put("populationLabel", this._populationDAO.getUserPopulation(((UserIdentity)entry.getKey()).getPopulationId()).getLabel());
                userPermissions.put("userSortableName", user.getSortableName());
                userPermissions.put("result", Map.of("accessResult", ((AccessExplanation)userExplanations.get(0)).accessResult(), "accessExplanations", userExplanations));
                json.add(userPermissions);
            }
        }
        if (!(anonymous = uses.usesForAnonymous().getOrDefault(object, List.of())).isEmpty()) {
            anonymous.sort(Comparator.naturalOrder());
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("targetType", ProfileAssignmentsToolClientSideElement.TargetType.ANONYMOUS.toString());
            hashMap.put("result", Map.of("accessResult", ((AccessExplanation)anonymous.get(0)).accessResult(), "accessExplanations", anonymous));
            json.add(hashMap);
        }
        if (!(list = uses.usesForAnyConnected().getOrDefault(object, List.of())).isEmpty()) {
            list.sort(Comparator.naturalOrder());
            HashMap<String, Object> anyconnectedPermissions = new HashMap<String, Object>();
            anyconnectedPermissions.put("targetType", ProfileAssignmentsToolClientSideElement.TargetType.ANYCONNECTED_USER.toString());
            anyconnectedPermissions.put("result", Map.of("accessResult", ((AccessExplanation)list.get(0)).accessResult(), "accessExplanations", list));
            json.add(anyconnectedPermissions);
        }
        return json;
    }

    protected record ProfileUses(Map<AccessController.ExplanationObject, List<AccessExplanation>> usesForAnonymous, Map<AccessController.ExplanationObject, List<AccessExplanation>> usesForAnyConnected, Map<AccessController.ExplanationObject, Map<GroupIdentity, List<AccessExplanation>>> usesByGroups, Map<AccessController.ExplanationObject, Map<UserIdentity, List<AccessExplanation>>> usesByUser) {
    }
}

