/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.script;

import jakarta.mail.MessagingException;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.core.ui.script.ScriptHandler;
import org.ametys.plugins.core.ui.script.ScriptResultFormatter;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.PluginsManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;

public class AsyncScriptHandler
extends ScriptHandler
implements Initializable {
    public static final String COMPONENT_ROLE = AsyncScriptHandler.class.getName();
    private static final String __ASYNC_EXECUTE_MAIL_SUBJECT_KEY = "PLUGINS_CORE_UI_SCRIPT_ASYNC_EXECUTE_MAIL_SUBJECT";
    private static final String __ASYNC_EXECUTE_MAIL_SUBJECT_ERROR_KEY = "PLUGINS_CORE_UI_SCRIPT_ASYNC_EXECUTE_MAIL_SUBJECT_ERROR";
    private static final String __ASYNC_EXECUTE_MAIL_BODY_KEY = "PLUGINS_CORE_UI_SCRIPT_ASYNC_EXECUTE_MAIL_BODY";
    private static final String __ASYNC_EXECUTE_MAIL_UNDEFINED = "PLUGINS_CORE_UI_SCRIPT_ASYNC_EXECUTE_MAIL_UNDEFINED";
    private Function<String, String> _mailSenderProvider;

    public void initialize() throws Exception {
        this._initializeMailSenderProvider();
    }

    protected void _initializeMailSenderProvider() {
        if (PluginsManager.getInstance().isSafeMode()) {
            this._mailSenderProvider = mailRecipient -> mailRecipient;
        } else {
            String mailSender = (String)Config.getInstance().getValue("smtp.mail.from");
            this._mailSenderProvider = mailRecipient -> mailSender;
        }
    }

    @Override
    protected ScriptHandler.ResultProcessor getProcessor() {
        return new AsyncResultProcessor();
    }

    public void sendReportMail(Map<String, Object> scriptResults, UserIdentity user, String mailRecipient, Locale locale, Logger logger) throws MessagingException, IOException {
        if (StringUtils.isNotBlank((CharSequence)mailRecipient)) {
            String output = (String)scriptResults.get("output");
            String error = StringUtils.defaultString((String)((String)scriptResults.get("error")));
            String errorMessage = StringUtils.defaultString((String)((String)scriptResults.get("message")));
            String errorStacktrace = StringUtils.defaultString((String)((String)scriptResults.get("stacktrace")));
            List attachments = (List)scriptResults.get("attachments");
            Object result = scriptResults.getOrDefault("result", "");
            String i18nCatalog = "plugin.core-ui";
            I18nizableText undefinedText = new I18nizableText(i18nCatalog, __ASYNC_EXECUTE_MAIL_UNDEFINED);
            ZonedDateTime startDate = this._getZDTFromScriptResults(scriptResults, "start");
            ZonedDateTime endDate = startDate != null ? this._getZDTFromScriptResults(scriptResults, "end") : null;
            I18nizableText duration = Optional.ofNullable(endDate).map(end -> Duration.between(startDate, endDate)).map(Duration::toMillis).map(DurationFormatUtils::formatDurationHMS).map(I18nizableText::new).orElse(undefinedText);
            I18nizableText start = Optional.ofNullable(startDate).map(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG).withLocale(locale).withZone(ZoneId.systemDefault())::format).map(I18nizableText::new).orElse(undefinedText);
            String language = locale.getLanguage();
            String htmlBody = this._i18nUtils.translate(new I18nizableText(i18nCatalog, __ASYNC_EXECUTE_MAIL_BODY_KEY, Map.of("out", new I18nizableText(output), "htmlResult", new I18nizableText(ScriptResultFormatter.htmlFormatResult(result)), "error", new I18nizableText(error), "message", new I18nizableText(errorMessage), "htmlStacktrace", new I18nizableText(ScriptResultFormatter.htmlFormatStacktrace(errorStacktrace)), "start", start, "duration", duration)), language);
            String title = this._mailTitle(i18nCatalog, errorStacktrace, language);
            String mailSender = this._mailSenderProvider.apply(mailRecipient);
            SendMailHelper.newMail().withSubject(title).withHTMLBody(htmlBody).withAttachments(attachments).withRecipient(mailRecipient).withSender(mailSender).sendMail();
        } else {
            logger.warn("User {} launched an asynchronous script but there is no email to send the output.", (Object)user);
        }
    }

    private ZonedDateTime _getZDTFromScriptResults(Map<String, Object> scriptResults, String paramName) {
        return Optional.of(paramName).map(scriptResults::get).map(String.class::cast).map(DateUtils::parseZonedDateTime).orElse(null);
    }

    private String _mailTitle(String i18nCatalog, String errorStacktrace, String language) {
        String i18nKey = StringUtils.isEmpty((CharSequence)errorStacktrace) ? __ASYNC_EXECUTE_MAIL_SUBJECT_KEY : __ASYNC_EXECUTE_MAIL_SUBJECT_ERROR_KEY;
        return this._i18nUtils.translate(new I18nizableText(i18nCatalog, i18nKey), language);
    }

    static class AsyncResultProcessor
    extends ScriptHandler.ResultProcessor {
        AsyncResultProcessor() {
        }

        @Override
        protected Object process(Map<String, Object> results, Object scriptResult) {
            if (scriptResult instanceof File) {
                List attachments = (List)results.computeIfAbsent("attachments", __ -> new ArrayList());
                attachments.add((File)scriptResult);
                return ((File)scriptResult).getName();
            }
            return super.process(results, scriptResult);
        }
    }
}

