/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.runtime.i18n.I18nizableText;

public class ScriptBindingDocumentation {
    private I18nizableText _name;
    private I18nizableText _text;
    private Signature _signature;
    private List<Example> _examples;

    public ScriptBindingDocumentation(I18nizableText name, I18nizableText text, Signature signature, List<Example> examples) {
        this._name = name;
        this._text = text;
        this._signature = signature;
        this._examples = examples;
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("name", this.getName());
        m.put("description", this.getText());
        m.put("signature", this.getSignature().asMap());
        m.put("examples", this.getExamples() != null ? this.getExamples().stream().map(Example::asMap).collect(Collectors.toList()) : null);
        return m;
    }

    public I18nizableText getName() {
        return this._name;
    }

    public I18nizableText getText() {
        return this._text;
    }

    public Signature getSignature() {
        return this._signature;
    }

    public List<Example> getExamples() {
        return this._examples;
    }

    public static class Signature {
        private String _returnType;
        private List<Argument> _returnSubtype;
        private I18nizableText _returnText;
        private List<Argument> _arguments;

        public Signature(String returnType, List<Argument> signatureSubtype, I18nizableText returnText, List<Argument> arguments) {
            this._returnType = returnType;
            this._returnSubtype = signatureSubtype;
            this._returnText = returnText;
            this._arguments = arguments;
        }

        public Map<String, Object> asMap() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("type", this.getType());
            List<Argument> subtype = this.getSubtype();
            if (subtype != null) {
                ArrayList<Map<String, Object>> subm = new ArrayList<Map<String, Object>>();
                for (Argument argument : this.getSubtype()) {
                    subm.add(argument.asMap());
                }
                m.put("subtype", subm);
            }
            m.put("text", this.getText());
            m.put("arguments", this.getArguments() != null ? this.getArguments().stream().map(Argument::asMap).collect(Collectors.toList()) : null);
            return m;
        }

        public String getType() {
            return this._returnType;
        }

        public List<Argument> getSubtype() {
            return this._returnSubtype;
        }

        public I18nizableText getText() {
            return this._returnText;
        }

        public List<Argument> getArguments() {
            return this._arguments;
        }
    }

    public static class Example {
        private String _code;
        private I18nizableText _exampleText;

        public Example(String code, I18nizableText text) {
            this._code = code;
            this._exampleText = text;
        }

        public Map<String, Object> asMap() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("code", this.getCode());
            m.put("text", this.getText());
            return m;
        }

        public String getCode() {
            return this._code;
        }

        public I18nizableText getText() {
            return this._exampleText;
        }
    }

    public static class Argument {
        private String _argumentName;
        private String _argumentType;
        private List<Argument> _argumentSubtype;
        private I18nizableText _argumentText;
        private String _argumentOptionalValue;

        public Argument(String argumentName, String argumentType, List<Argument> argumentSubtype, I18nizableText argumentText, String optionalValue) {
            this._argumentName = argumentName;
            this._argumentType = argumentType;
            this._argumentSubtype = argumentSubtype;
            this._argumentText = argumentText;
            this._argumentOptionalValue = optionalValue;
        }

        public Map<String, Object> asMap() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("name", this.getName());
            m.put("type", this.getType());
            List<Argument> subtype = this.getSubtype();
            if (subtype != null) {
                ArrayList<Map<String, Object>> subm = new ArrayList<Map<String, Object>>();
                for (Argument argument : this.getSubtype()) {
                    subm.add(argument.asMap());
                }
                m.put("subtype", subm);
            }
            m.put("text", this.getText());
            m.put("optional", this.getOptionalValue());
            return m;
        }

        public String getName() {
            return this._argumentName;
        }

        public String getType() {
            return this._argumentType;
        }

        public List<Argument> getSubtype() {
            return this._argumentSubtype;
        }

        public I18nizableText getText() {
            return this._argumentText;
        }

        public String getOptionalValue() {
            return this._argumentOptionalValue;
        }
    }
}

