/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.script;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.model.type.ModelItemTypeExtensionPoint;
import org.ametys.core.schedule.progression.ProgressionTracker;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.core.ui.script.ScriptBinding;
import org.ametys.plugins.core.ui.script.ScriptBindingDocumentation;
import org.ametys.plugins.core.ui.script.ScriptBindingExtensionPoint;
import org.ametys.plugins.core.ui.script.ScriptExecArguments;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class ScriptHandler
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = ScriptHandler.class.getName();
    protected static final String RIGHT_EXECUTE_SCRIPTS = "CORE_Rights_ExecuteScript";
    private static final String __SCRIPT_INSERT_CLEANUP_MANAGER = "var __cleanup_manager = {\n    _registered: {},\n    register: function(registerId, f)\n    {\n        let registeredFunctions = this._registered[registerId] || [];\n        registeredFunctions.push(f);\n        this._registered[registerId] = registeredFunctions;\n    },\n    cleanup: function(registerId)\n    {\n        if (registerId)\n        {\n            let registeredFunctions = this._registered[registerId];\n            if (registeredFunctions)\n            {\n                registeredFunctions.forEach(f => f());\n            }\n            delete this._registered[registerId];\n        }\n        else\n        {\n            Object.keys(this._registered).forEach(id => this.cleanup(id));\n        }\n    }\n};";
    private static final String __SCRIPT_INSERT_RUN_MAIN = "var __result; try { __result = main(); } finally { __cleanup_manager.cleanup() } __result";
    protected ScriptBindingExtensionPoint _scriptBindingEP;
    protected I18nUtils _i18nUtils;
    protected org.apache.avalon.framework.context.Context _context;
    private ModelItemTypeExtensionPoint _scriptModelItemTypeExtensionPoint;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._scriptBindingEP = (ScriptBindingExtensionPoint)serviceManager.lookup(ScriptBindingExtensionPoint.ROLE);
        this._i18nUtils = (I18nUtils)((Object)serviceManager.lookup(I18nUtils.ROLE));
        this._scriptModelItemTypeExtensionPoint = (ModelItemTypeExtensionPoint)serviceManager.lookup(ModelItemTypeExtensionPoint.ROLE_SCRIPT);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
    }

    protected ScriptExecArguments buildExecArguments(Map<String, Object> arguments) {
        return new ScriptExecArguments.Impl(arguments);
    }

    @Callable(rights={"CORE_Rights_ExecuteScript"}, context="/${WorkspaceName}")
    public Map<String, Object> executeScript(Map<String, Object> arguments) {
        ScriptExecArguments execArgs = this.buildExecArguments(arguments);
        String workspaceName = this.getWorkspaceName();
        return this._executeScript(execArgs, null, workspaceName);
    }

    public Map<String, Object> executeScript(String script, Map<String, Object> scriptVariables, String workspaceName) {
        return this.executeScript(script, scriptVariables, workspaceName, null);
    }

    public Map<String, Object> executeScript(String script, Map<String, Object> scriptVariables, String workspaceName, ProgressionTracker progressionTracker) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("script", script);
        if (progressionTracker != null) {
            arguments.put("progressionTracker", progressionTracker);
        }
        ScriptExecArguments execArgs = this.buildExecArguments(arguments);
        return this._executeScript(execArgs, scriptVariables, workspaceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> _executeScript(ScriptExecArguments arguments, Map<String, Object> scriptVariables, String workspaceName) {
        String nonEmptyWorkspaceName = StringUtils.isEmpty((CharSequence)workspaceName) ? "admin" : workspaceName;
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("start", DateUtils.dateToString(new Date()));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayOutputStream errorOutput = new ByteArrayOutputStream();
        HostAccess hostAccess = HostAccess.newBuilder((HostAccess)HostAccess.ALL).targetTypeMapping(List.class, Object.class, null, v -> v).build();
        Context polyglotContext = Context.newBuilder((String[])new String[]{"js"}).allowAllAccess(true).allowHostAccess(hostAccess).option("engine.WarnInterpreterOnly", "false").out((OutputStream)output).err((OutputStream)errorOutput).build();
        String scriptName = "generated script";
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (scriptVariables != null) {
            variables.putAll(scriptVariables);
        }
        variables.putAll(this._addParameterizedVariables(arguments));
        List<ScriptBinding> scriptBindings = this._scriptBindingEP.getScriptBindings(nonEmptyWorkspaceName);
        try {
            try (Context context = polyglotContext;){
                ArrayList<String> scriptTexts = new ArrayList<String>();
                String script = arguments.script();
                scriptTexts.add(script);
                scriptTexts.add(__SCRIPT_INSERT_CLEANUP_MANAGER);
                this._setScriptBindings(variables, scriptTexts, scriptBindings, arguments);
                scriptTexts.add(__SCRIPT_INSERT_RUN_MAIN);
                Value jsBindings = polyglotContext.getBindings("js");
                for (Map.Entry entry : variables.entrySet()) {
                    jsBindings.putMember((String)entry.getKey(), entry.getValue());
                }
                String scriptText = StringUtils.join(scriptTexts, (String)"\n");
                Source source = Source.newBuilder((String)"js", (CharSequence)scriptText, (String)"generated script").build();
                Object scriptResult = polyglotContext.eval(source).as(Object.class);
                if (scriptResult != null) {
                    results.put("result", this.processScriptResult(results, scriptResult, arguments));
                }
            }
            results.put("end", DateUtils.dateToString(new Date()));
        }
        catch (Throwable t) {
            try {
                Throwable e = t;
                if (t instanceof PolyglotException) {
                    e = new PolyglotWithCauseException((PolyglotException)t);
                }
                results.put("message", StringUtils.defaultString((String)e.getMessage()));
                results.put("stacktrace", ExceptionUtils.getStackTrace((Throwable)e));
                this.getLogger().error("An exception occurred while running script", e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                results.put("end", DateUtils.dateToString(new Date()));
                results.put("output", output.toString());
                results.put("error", errorOutput.toString());
                for (String extensionId : this._scriptBindingEP.getExtensionsIds()) {
                    ScriptBinding scriptBinding = (ScriptBinding)this._scriptBindingEP.getExtension(extensionId);
                    scriptBinding.cleanVariables(variables);
                }
            }
        }
        results.put("output", output.toString());
        results.put("error", errorOutput.toString());
        for (String extensionId : this._scriptBindingEP.getExtensionsIds()) {
            ScriptBinding scriptBinding = (ScriptBinding)this._scriptBindingEP.getExtension(extensionId);
            scriptBinding.cleanVariables(variables);
        }
        return results;
    }

    protected Map<String, Object> _addParameterizedVariables(ScriptExecArguments execArgs) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Map<String, Object> parameters = execArgs.parameters();
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                Map scriptValue = (Map)entry.getValue();
                String typeId = (String)scriptValue.get("type");
                ElementType type = (ElementType)this._scriptModelItemTypeExtensionPoint.getExtension(typeId);
                if (type == null) {
                    throw new IllegalArgumentException("The script cannot handle type '" + typeId + "' for parameters.");
                }
                Object value = type.fromJSONForClient(scriptValue.get("value"), DataContext.newInstance());
                variables.put(entry.getKey(), value);
            }
        }
        return variables;
    }

    private void _setScriptBindings(Map<String, Object> variables, List<String> scriptText, List<ScriptBinding> scriptBindings, ScriptExecArguments execArgs) {
        scriptText.add("Ametys = {};Ametys.namespace = function(namespace, attributes) {    var namespaces = namespace.split(\".\");    var prefix = \"\";    for (var i = 0; i < namespaces.length; i++)    {        var ns = (prefix ? prefix + \".\" : \"\") + namespaces[i];         eval(\"try {\" + ns + \" = \" + ns + \" || {} } catch (e) {\" + ns + \" = {}}\");        prefix = ns;    }    var newNamespace = eval(namespace);    if (attributes)    {        for (var i in attributes)        {            newNamespace[i] = attributes[i];        }    }    return newNamespace;}");
        for (ScriptBinding scriptBinding : scriptBindings) {
            String scriptVariables;
            Map<String, Object> scriptBindingVariables = scriptBinding.getVariables(execArgs);
            if (scriptBindingVariables != null) {
                variables.putAll(scriptBindingVariables);
            }
            if ((scriptVariables = scriptBinding.getVariablesScripts()) == null) continue;
            scriptText.add(scriptVariables);
        }
        for (ScriptBinding scriptBinding : scriptBindings) {
            String scriptBindingFunctions = scriptBinding.getFunctions();
            if (scriptBindingFunctions == null) continue;
            scriptText.add(scriptBindingFunctions);
        }
    }

    protected Object processScriptResult(Map<String, Object> results, Object scriptResult, ScriptExecArguments execArgs) {
        return this.getProcessor().process(results, scriptResult);
    }

    protected ResultProcessor getProcessor() {
        return new ResultProcessor();
    }

    private void _addToBinding(List<Map<String, Object>> descriptionsList, Map<? extends Object, ScriptBindingDocumentation> descriptions, String type) {
        if (descriptions != null) {
            for (Map.Entry<? extends Object, ScriptBindingDocumentation> description : descriptions.entrySet()) {
                Object name = description.getKey();
                String id = type + "-" + String.valueOf(name);
                HashMap<String, Object> scriptVariable = new HashMap<String, Object>();
                scriptVariable.put("id", id);
                scriptVariable.put("type", type);
                scriptVariable.putAll(description.getValue().asMap());
                if (descriptionsList.stream().map(e -> e.get("id")).anyMatch(i -> id.equals(i))) {
                    this.getLogger().warn("Multiple ScriptBinding use the same " + type + " name : '" + String.valueOf(name) + "'. Only one of these " + type + "s will be available and the associated documentation may not match.");
                    continue;
                }
                descriptionsList.add(scriptVariable);
            }
        }
    }

    @Callable(rights={"CORE_Rights_ExecuteScript"})
    public List<Map<String, Object>> getScriptBindingDescription() {
        ArrayList<Map<String, Object>> descriptionsList = new ArrayList<Map<String, Object>>();
        List<ScriptBinding> scriptBindings = this._scriptBindingEP.getScriptBindings(this.getWorkspaceName());
        for (ScriptBinding scriptBinding : scriptBindings) {
            this._addToBinding(descriptionsList, scriptBinding.getVariablesDescriptions(), "variable");
            this._addToBinding(descriptionsList, scriptBinding.getFunctionsDescriptions(), "function");
            this._addToBinding(descriptionsList, scriptBinding.getTutorials(), "tutorial");
        }
        return descriptionsList;
    }

    protected String getWorkspaceName() {
        return Optional.of(this._context).map(ContextHelper::getRequest).map(req -> req.getAttribute("workspaceName")).filter(String.class::isInstance).map(String.class::cast).orElse("admin");
    }

    private static final class PolyglotWithCauseException
    extends RuntimeException {
        PolyglotException _initial;

        PolyglotWithCauseException(PolyglotException initial) {
            super(initial.getMessage());
            this._initial = initial;
        }

        private String _getStackTrace() {
            StringBuffer sb = new StringBuffer();
            if (this._initial.isHostException()) {
                sb.append(StringUtils.substringBefore((String)ExceptionUtils.getStackTrace((Throwable)this._initial), (String)"Caused by host exception:"));
                Throwable subException = this._initial.asHostException();
                if (subException.getCause() != null) {
                    sb.append("Caused by: ");
                    sb.append(ExceptionUtils.getStackTrace((Throwable)subException.getCause()));
                }
            } else {
                sb.append(ExceptionUtils.getStackTrace((Throwable)this._initial));
            }
            return sb.toString();
        }

        @Override
        public void printStackTrace(PrintStream s) {
            s.append(this._getStackTrace());
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            s.append(this._getStackTrace());
        }
    }

    protected static class ResultProcessor {
        protected ResultProcessor() {
        }

        protected Object process(Map<String, Object> results, Object scriptResult) {
            if (scriptResult instanceof Collection) {
                ArrayList<Object> elements = new ArrayList<Object>();
                for (Object obj : (Collection)scriptResult) {
                    elements.add(this.process(results, obj));
                }
                return elements;
            }
            if (scriptResult instanceof Iterator) {
                ArrayList<Object> objs = new ArrayList<Object>();
                Iterator it = (Iterator)scriptResult;
                while (it.hasNext()) {
                    objs.add(this.process(results, it.next()));
                }
                return objs;
            }
            if (scriptResult instanceof Map) {
                HashMap<Object, Object> elements = new HashMap<Object, Object>();
                for (Object key : ((Map)scriptResult).keySet()) {
                    Object value = ((Map)scriptResult).get(key);
                    Object elementKey = this.process(results, key);
                    Object elementValue = this.process(results, value);
                    elements.put(elementKey, elementValue);
                }
                return elements;
            }
            return this._processSingleObject(scriptResult);
        }

        protected Object _processSingleObject(Object scriptResult) {
            return scriptResult != null ? scriptResult.toString() : null;
        }
    }
}

