/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.script;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ametys.core.model.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.core.ui.script.ScriptBinding;
import org.ametys.plugins.core.ui.script.ScriptBindingDocumentation;
import org.ametys.plugins.core.ui.script.ScriptExecArguments;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.xml.sax.SAXException;

public class StaticConfigurableScriptBinding
extends AbstractLogEnabled
implements ScriptBinding,
Configurable,
Serviceable,
PluginAware,
Contextualizable {
    protected SourceResolver _sourceResolver;
    protected List<String> _variablesScripts;
    protected List<String> _functions;
    protected Map<String, ScriptBindingDocumentation> _functionsDescriptions;
    protected Map<String, ScriptBindingDocumentation> _variablesDescriptions;
    protected String _pluginName;
    protected Pattern _workspacePattern;
    protected Context _context;
    protected Map<I18nizableText, ScriptBindingDocumentation> _tutorials;
    protected I18nParameterResolver _i18nParameterResolver;
    private ModelItemTypeExtensionPoint _scriptModelItemTypeExtensionPoint;

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._scriptModelItemTypeExtensionPoint = (ModelItemTypeExtensionPoint)manager.lookup(ModelItemTypeExtensionPoint.ROLE_SCRIPT);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._i18nParameterResolver = new I18nParameterResolver(this._scriptModelItemTypeExtensionPoint);
        String workspacePattern = configuration.getChild("workspace").getValue(".*");
        this._workspacePattern = Pattern.compile(workspacePattern);
        this._variablesScripts = new ArrayList<String>();
        this._variablesDescriptions = new HashMap<String, ScriptBindingDocumentation>();
        this._functions = new ArrayList<String>();
        this._functionsDescriptions = new HashMap<String, ScriptBindingDocumentation>();
        this._tutorials = new HashMap<I18nizableText, ScriptBindingDocumentation>();
        String pluginName = configuration.getChild("file").getAttribute("plugin", this._pluginName);
        String filePath = configuration.getChild("file").getValue(null);
        if (StringUtils.isNotEmpty((CharSequence)filePath)) {
            filePath = this._getURI(pluginName, filePath, null);
        }
        Configuration fileConfiguration = StringUtils.isNotEmpty((CharSequence)filePath) ? this._getFileConfiguration(filePath, configuration) : configuration;
        try {
            this._configureVariables(pluginName, filePath, fileConfiguration);
            this._configureFunctions(pluginName, filePath, fileConfiguration);
            this._configureTutorials(pluginName, filePath, fileConfiguration);
        }
        catch (IOException e) {
            throw new ConfigurationException("An error occurred while configuring the script binding", fileConfiguration, (Throwable)e);
        }
    }

    protected void _configureFunctions(String pluginName, String filePath, Configuration configuration) throws ConfigurationException, IOException {
        Configuration functionsConf = configuration.getChild("functions", false);
        if (functionsConf != null) {
            for (Configuration functionConf : functionsConf.getChildren("function")) {
                for (Configuration scriptConf : functionConf.getChildren("script")) {
                    this._functions.add(this._getContent(pluginName, filePath, scriptConf));
                }
                ScriptBindingDocumentation d = this._parseDocumentation(pluginName, filePath, functionConf);
                this._functionsDescriptions.put(d.getName().getLabel(), d);
            }
        }
    }

    protected void _configureVariables(String pluginName, String filePath, Configuration configuration) throws ConfigurationException, IOException {
        Configuration variablesConf = configuration.getChild("variables", false);
        if (variablesConf != null) {
            for (Configuration variableConf : variablesConf.getChildren("variable")) {
                for (Configuration scriptConf : variableConf.getChildren("script")) {
                    this._variablesScripts.add(this._getContent(pluginName, filePath, scriptConf));
                }
                ScriptBindingDocumentation d = this._parseDocumentation(pluginName, filePath, variableConf);
                this._variablesDescriptions.put(d.getName().getLabel(), d);
            }
        }
    }

    protected void _configureTutorials(String pluginName, String filePath, Configuration configuration) throws ConfigurationException, IOException {
        Configuration tutorialsConf = configuration.getChild("tutorials", false);
        if (tutorialsConf != null) {
            for (Configuration tutorialConf : tutorialsConf.getChildren("tutorial")) {
                ScriptBindingDocumentation d = this._parseDocumentation(pluginName, filePath, tutorialConf);
                this._tutorials.put(d.getName(), d);
            }
        }
    }

    protected ScriptBindingDocumentation _parseDocumentation(String pluginName, String filePath, Configuration initialConfiguration) throws ConfigurationException, IOException {
        I18nizableText name = I18nizableText.parseI18nizableText(initialConfiguration.getChild("name", false), "plugin." + pluginName, "");
        I18nizableText text = this._parseI18nizableTextWithVariables(initialConfiguration.getChild("text", false), "plugin." + pluginName);
        Configuration signatureConfiguration = initialConfiguration.getChild("signature", true);
        String signatureType = signatureConfiguration.getChild("type", true).getValue(null);
        I18nizableText signatureText = I18nizableText.parseI18nizableText(signatureConfiguration.getChild("text", false), "plugin." + pluginName, "");
        List<ScriptBindingDocumentation.Argument> signatureSubtype = this._configureSubtype(signatureConfiguration, pluginName);
        ArrayList<ScriptBindingDocumentation.Argument> arguments = null;
        Configuration argumentsConfiguration = signatureConfiguration.getChild("arguments", false);
        if (argumentsConfiguration != null) {
            arguments = new ArrayList<ScriptBindingDocumentation.Argument>();
            for (Configuration configuration : argumentsConfiguration.getChildren("argument")) {
                ScriptBindingDocumentation.Argument argument = this._parseArgument(configuration, pluginName);
                arguments.add(argument);
            }
        }
        ScriptBindingDocumentation.Signature signature = new ScriptBindingDocumentation.Signature(signatureType, signatureSubtype, signatureText, arguments);
        ArrayList<ScriptBindingDocumentation.Example> examples = null;
        Configuration examplesConfiguration = initialConfiguration.getChild("examples", false);
        if (examplesConfiguration != null) {
            examples = new ArrayList<ScriptBindingDocumentation.Example>();
            for (Configuration exampleConfiguration : examplesConfiguration.getChildren("example")) {
                String code = this._getContent(pluginName, filePath, exampleConfiguration.getChild("script"));
                I18nizableText exampleText = I18nizableText.parseI18nizableText(exampleConfiguration.getChild("text", false), "plugin." + pluginName, "");
                ScriptBindingDocumentation.Example example = new ScriptBindingDocumentation.Example(code, exampleText);
                examples.add(example);
            }
        }
        ScriptBindingDocumentation scriptBindingDocumentation = new ScriptBindingDocumentation(name, text, signature, examples);
        return scriptBindingDocumentation;
    }

    private I18nizableText _parseI18nizableTextWithVariables(Configuration configuration, String defaultCatalogue) {
        String i18nParams;
        I18nizableText text = I18nizableText.parseI18nizableText(configuration, defaultCatalogue, "");
        if (text.isI18n() && StringUtils.isNotBlank((CharSequence)(i18nParams = configuration.getAttribute("i18n-parameters", null)))) {
            HashMap<String, I18nizableTextParameter> params = new HashMap<String, I18nizableTextParameter>();
            for (String i18nParamName : StringUtils.split((String)i18nParams, (char)',')) {
                I18nizableTextParameter i18nParamValue = this._i18nParameterResolver.resolveVariables(i18nParamName.trim());
                if (i18nParamValue == null) {
                    throw new IllegalArgumentException("Unknown i18n parameter '" + i18nParamName + "'");
                }
                params.put(i18nParamName, i18nParamValue);
            }
            text = new I18nizableText(text.getCatalogue(), text.getKey(), params);
        }
        return text;
    }

    private List<ScriptBindingDocumentation.Argument> _configureSubtype(Configuration configuration, String pluginName) {
        Configuration subtypeConfiguration = configuration.getChild("subtype", false);
        if (subtypeConfiguration == null) {
            return null;
        }
        ArrayList<ScriptBindingDocumentation.Argument> subtype = new ArrayList<ScriptBindingDocumentation.Argument>();
        for (Configuration argumentConfiguration : subtypeConfiguration.getChildren("argument")) {
            ScriptBindingDocumentation.Argument argument = this._parseArgument(argumentConfiguration, pluginName);
            subtype.add(argument);
        }
        return subtype;
    }

    private ScriptBindingDocumentation.Argument _parseArgument(Configuration argumentConfiguration, String pluginName) {
        String argumentName = argumentConfiguration.getChild("name", true).getValue(null);
        String argumentType = argumentConfiguration.getChild("type", true).getValue(null);
        I18nizableText argumentText = I18nizableText.parseI18nizableText(argumentConfiguration.getChild("text", false), "plugin." + pluginName, "");
        String argumentOptionalValue = argumentConfiguration.getChild("optional", true).getValue(null);
        List<ScriptBindingDocumentation.Argument> argumentSubtype = this._configureSubtype(argumentConfiguration, pluginName);
        return new ScriptBindingDocumentation.Argument(argumentName, argumentType, argumentSubtype, argumentText, argumentOptionalValue);
    }

    private String _getContent(String pluginName, String filePath, Configuration initialConfiguration) throws ConfigurationException, IOException {
        if (initialConfiguration != null) {
            String fileName = initialConfiguration.getAttribute("file", null);
            String value = StringUtils.isEmpty((CharSequence)fileName) ? initialConfiguration.getValue() : this._getRelativeFileContent(pluginName, fileName, filePath);
            return value;
        }
        return null;
    }

    private Configuration _getFileConfiguration(String uri, Configuration initialConfiguration) {
        try {
            Configuration fileConfiguration = this._getConfiguration(uri);
            return fileConfiguration;
        }
        catch (SourceNotFoundException e) {
            this.getLogger().info("No script binding file was found at {}. Using internally declared config.", (Object)uri);
        }
        catch (IOException | ConfigurationException | SAXException exception) {
            this.getLogger().error("The script binding file at {} cannot be read. Using internally declared config.", (Object)uri, (Object)exception);
        }
        return initialConfiguration;
    }

    private String _getURI(String pluginName, String filePath, String relativeTo) {
        if (filePath.startsWith("/")) {
            return "context:/" + filePath;
        }
        if (StringUtils.isNotEmpty((CharSequence)relativeTo)) {
            return SourceUtil.absolutize((String)relativeTo, (String)filePath);
        }
        return "plugin:" + pluginName + "://" + filePath;
    }

    /*
     * Loose catch block
     */
    private String _getRelativeFileContent(String pluginName, String filePath, String relativeTo) throws IOException {
        String string;
        InputStream is;
        Source source;
        block10: {
            block9: {
                source = null;
                String uri = this._getURI(pluginName, filePath, relativeTo);
                source = this._sourceResolver.resolveURI(uri);
                is = source.getInputStream();
                string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                if (is == null) break block9;
                is.close();
            }
            if (source == null) break block10;
            this._sourceResolver.release(source);
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    if (source != null) {
                        this._sourceResolver.release(source);
                    }
                    throw throwable3;
                }
            }
        }
    }

    private Configuration _getConfiguration(String uri) throws ConfigurationException, SAXException, IOException {
        Source source = null;
        try {
            Configuration configuration;
            block10: {
                source = this._sourceResolver.resolveURI(uri);
                InputStream is = source.getInputStream();
                try {
                    configuration = new DefaultConfigurationBuilder(true).build(is, uri);
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return configuration;
        }
        finally {
            if (source != null) {
                this._sourceResolver.release(source);
            }
        }
    }

    @Override
    public Pattern getWorkspacePattern() {
        return this._workspacePattern;
    }

    @Override
    public String getFunctions() {
        return StringUtils.join(this._functions, (String)"\n");
    }

    @Override
    public String getVariablesScripts() {
        return StringUtils.join(this._variablesScripts, (String)"\n");
    }

    @Override
    public Map<String, ScriptBindingDocumentation> getFunctionsDescriptions() {
        return this._functionsDescriptions;
    }

    @Override
    public Map<I18nizableText, ScriptBindingDocumentation> getTutorials() {
        return this._tutorials;
    }

    @Override
    public Map<String, Object> getVariables(ScriptExecArguments execArgs) {
        return null;
    }

    @Override
    public Map<String, ScriptBindingDocumentation> getVariablesDescriptions() {
        return this._variablesDescriptions;
    }

    @Override
    public void cleanVariables(Map<String, Object> variables) {
    }

    private static final class I18nParameterResolver {
        private ModelItemTypeExtensionPoint _scriptModelItemTypeExtensionPoint;

        private I18nParameterResolver(ModelItemTypeExtensionPoint scriptModelItemTypeExtensionPoint) {
            this._scriptModelItemTypeExtensionPoint = scriptModelItemTypeExtensionPoint;
        }

        private I18nizableTextParameter resolveVariables(String i18nParameterName) {
            if ("script-parameter-types".equals(i18nParameterName)) {
                String typesValue = this._scriptModelItemTypeExtensionPoint.getExtensionsIds().stream().sorted().collect(Collectors.joining(", "));
                return new I18nizableText(typesValue);
            }
            return null;
        }
    }
}

