/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.system;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import org.ametys.core.util.SystemStatus;
import org.ametys.core.version.Version;
import org.ametys.core.version.VersionsHandler;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class StartupGenerator
extends ServiceableGenerator {
    private static String __version;
    private SystemStatus _systemStatus;

    public void service(ServiceManager sm) throws ServiceException {
        super.service(sm);
        this._systemStatus = (SystemStatus)sm.lookup(SystemStatus.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        if (__version == null) {
            VersionsHandler handler;
            try {
                handler = (VersionsHandler)this.manager.lookup(VersionsHandler.ROLE);
            }
            catch (ServiceException e) {
                String errorMessage = "Unable to get the VersionsHandler";
                this.getLogger().error(errorMessage, (Throwable)e);
                throw new ProcessingException(errorMessage, (Throwable)e);
            }
            StringBuffer value = new StringBuffer();
            Collection<Version> versions = handler.getVersions();
            for (Version version : versions) {
                if (value.length() > 0) {
                    value.append(" / ");
                }
                value.append(version.getName());
                if (StringUtils.isNotBlank((CharSequence)version.getVersion())) {
                    value.append(" - ");
                    value.append(version.getVersion());
                }
                if (version.getDate() == null) continue;
                value.append(" - ");
                value.append(Long.toString(version.getDate().getTime()));
            }
            __version = Integer.toString(value.toString().hashCode());
        }
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("version", __version);
        attrs.addCDATAAttribute("status", StringUtils.join(this._systemStatus.getStatus(), (char)','));
        this.contentHandler.startDocument();
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"startup-time", (Attributes)attrs, (String)Long.toString(ManagementFactory.getRuntimeMXBean().getStartTime()));
        this.contentHandler.endDocument();
    }
}

