/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.system;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Map;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.runtime.plugins.admin.system.SystemHelper;
import org.ametys.runtime.servlet.RuntimeServlet;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SystemAnnouncementGenerator
extends ServiceableGenerator {
    private SystemHelper _systemHelper;
    private UserHelper _userHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._systemHelper = (SystemHelper)((Object)smanager.lookup(SystemHelper.ROLE));
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        SystemHelper.SystemAnnouncement systemAnnouncement = this._systemHelper.readValues();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("state", systemAnnouncement.getState());
        if (systemAnnouncement.getStartDate() != null) {
            attrs.addCDATAAttribute("start-date", DateUtils.zonedDateTimeToString(systemAnnouncement.getStartDate()));
        }
        if (systemAnnouncement.getEndDate() != null) {
            attrs.addCDATAAttribute("end-date", DateUtils.zonedDateTimeToString(systemAnnouncement.getEndDate()));
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"SystemAnnounce", (Attributes)attrs);
        boolean isAvailable = this._systemHelper.isSystemAnnouncementAvailable();
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"IsAvailable", (String)String.valueOf(isAvailable));
        if (isAvailable) {
            Locale locale = I18nUtils.findLocale((Map)this.objectModel, (String)"locale", null, (Locale)Locale.getDefault(), (boolean)true);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"LastModification", (String)String.valueOf(this._systemHelper.getSystemAnnoucementLastModificationDate()));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"Message", (String)this._systemHelper.getSystemAnnouncement(locale.getLanguage()));
        }
        attrs.clear();
        attrs.addCDATAAttribute("active", RuntimeServlet.getRunMode() == RuntimeServlet.RunMode.MAINTENANCE ? "true" : "false");
        attrs.addCDATAAttribute("mode", RuntimeServlet.getMaintenanceStatus().toString());
        long maintenanceTimestamp = ManagementFactory.getRuntimeMXBean().getStartTime();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"Maintenance", (Attributes)attrs);
        RuntimeServlet.ForcedMainteanceInformations maintenanceStatusForcedInformations = RuntimeServlet.getMaintenanceStatusForcedInformations();
        if (maintenanceStatusForcedInformations != null) {
            ZonedDateTime since;
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"comment", (String)RuntimeServlet.getMaintenanceStatusForcedInformations().comment());
            UserIdentity initiator = RuntimeServlet.getMaintenanceStatusForcedInformations().initiator();
            if (initiator != null) {
                String userFullName = StringUtils.defaultString((String)this._userHelper.getUserFullName(initiator));
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"initiator", (String)(userFullName + " (" + UserIdentity.userIdentityToString(initiator) + ")"));
            }
            if ((since = RuntimeServlet.getMaintenanceStatusForcedInformations().since()) != null) {
                maintenanceTimestamp = since.toInstant().getEpochSecond();
                String sinceAsString = DateUtils.zonedDateTimeToString(since);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"since", (String)sinceAsString);
            }
        }
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"timestamp", (String)Long.toString(maintenanceTimestamp));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"Maintenance");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"SystemAnnounce");
        this.contentHandler.endDocument();
    }
}

