/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.user;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.ImageHelper;
import org.ametys.plugins.core.ui.user.DefaultUserImageHelper;
import org.ametys.plugins.core.ui.user.ProfileImageProvider;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;
import org.xml.sax.SAXException;

public abstract class AbstractImageReader
extends ServiceableReader
implements CacheableProcessingComponent {
    public static final Collection<String> ALLOWED_IMG_FORMATS = Arrays.asList("png", "gif", "jpg", "jpeg");
    public static final Map<String, String> FORMATS_MIMETYPE = Map.of("png", "png", "gif", "gif", "jpg", "jpeg", "jpeg", "jpeg");
    protected CurrentUserProvider _currentUserProvider;
    protected ProfileImageProvider _profileImageProvider;
    protected DefaultUserImageHelper _defaultUserImageHelper;
    protected User.UserImage _image;
    protected int _size;
    protected int _maxSize;
    protected UserIdentity _user;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._profileImageProvider = (ProfileImageProvider)this.manager.lookup(ProfileImageProvider.ROLE);
        this._defaultUserImageHelper = (DefaultUserImageHelper)this.manager.lookup(DefaultUserImageHelper.ROLE);
    }

    public void setup(SourceResolver sresolver, Map mObjectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(sresolver, mObjectModel, src, par);
        this._user = this.getUser();
        this.initImage();
    }

    protected abstract void initImage() throws ProcessingException;

    public void generate() throws IOException, ProcessingException {
        boolean download = this.parameters.getParameterAsBoolean("download", false);
        try {
            Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
            this._readImage(response, this._user, this._image, download, this._size, this._maxSize);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.out);
        }
    }

    public long getLastModified() {
        Long lastModified = this._image.getLastModified();
        return lastModified != null ? lastModified : 0L;
    }

    public Serializable getKey() {
        return ((Object)((Object)this)).getClass().getName() + "$" + UserIdentity.userIdentityToString(this._user) + "$" + this._size + "$" + this._maxSize + "$" + this._image.getType();
    }

    public SourceValidity getValidity() {
        return new TimeStampValidity(this.getLastModified());
    }

    public String getMimeType() {
        if (this._image != null) {
            String filename = this._image.getFilename();
            String format = "png";
            if (StringUtils.isNotBlank((CharSequence)filename)) {
                format = FilenameUtils.getExtension((String)filename);
                format = ALLOWED_IMG_FORMATS.contains(format) ? format : "png";
            }
            return "image/" + FORMATS_MIMETYPE.get(format);
        }
        return super.getMimeType();
    }

    protected UserIdentity getUser() {
        String login = this.parameters.getParameter("login", "");
        String populationId = this.parameters.getParameter("populationId", "");
        if (StringUtils.isEmpty((CharSequence)login) || StringUtils.isEmpty((CharSequence)populationId)) {
            return this._currentUserProvider.getUser();
        }
        return new UserIdentity(login, populationId);
    }

    protected void _readImage(Response response, UserIdentity user, User.UserImage image, boolean download, int size, int maxSize) throws IOException {
        try (InputStream is = image.getInputstream();){
            String filename = (String)StringUtils.defaultIfEmpty((CharSequence)image.getFilename(), (CharSequence)(user.getLogin() + ".png"));
            String format = FilenameUtils.getExtension((String)filename);
            String string = format = ALLOWED_IMG_FORMATS.contains(format) ? format : "png";
            if (download) {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
            }
            if (size > 0 || maxSize > 0) {
                ImageHelper.generateThumbnail(is, this.out, format, 0, 0, maxSize, maxSize, size, size);
            } else {
                Long length = image.getLength();
                if (length != null && length > 0L) {
                    response.setHeader("Content-Length", Long.toString(length));
                }
                IOUtils.copy((InputStream)is, (OutputStream)this.out);
            }
        }
    }

    public void recycle() {
        super.recycle();
        if (this._image != null) {
            IOUtils.closeQuietly((Closeable)this._image);
            this._image = null;
        }
    }
}

