/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.user;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.imageio.ImageIO;
import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.ImageHelper;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.ui.user.AbstractImageReader;
import org.ametys.plugins.core.ui.user.SafeProfileImageProvider;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.xml.sax.SAXException;

public class DefaultProfileImageProvider
extends SafeProfileImageProvider
implements Contextualizable {
    protected static final String __AVATAR_DIR_NAME = "avatar";
    protected static final String __INITIALS_DIR_NAME = "initials";
    protected static Map<String, String> __avatarPaths;
    protected static List<String> __initialsBgPaths;
    protected UploadManager _uploadManager;
    protected JSONUtils _jsonUtils;
    private Context _context;
    private UserPreferencesManager _userPrefManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._uploadManager = (UploadManager)smanager.lookup(UploadManager.ROLE);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
        this._userPrefManager = (UserPreferencesManager)((Object)smanager.lookup(UserPreferencesManager.ROLE));
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public User.UserImage getImage(UserIdentity user, String imageSource, int size, int maxSize, Map<String, Object> userPrefSourceParams) {
        User.UserImage image = null;
        ProfileImageSource profileImageSource = this.getProfileImageSource(imageSource);
        if (profileImageSource != null) {
            Map<String, Object> sourceParams;
            Map<String, Object> map = sourceParams = userPrefSourceParams == null ? this._extractSourceParameters(user, profileImageSource) : userPrefSourceParams;
            if (sourceParams != null) {
                if (size > 0) {
                    sourceParams.put("size", size);
                }
                if (maxSize > 0) {
                    sourceParams.put("maxSize", maxSize);
                }
                image = this.getImage(profileImageSource, user, sourceParams);
            }
        }
        if (image == null) {
            image = this.getDefaultImageForUser(user, size, maxSize);
        }
        return image;
    }

    @Override
    public User.UserImage getDefaultImageForUser(UserIdentity user, int size, int maxSize) {
        User.UserImage image = this.getGravatarImage(user, size > 0 ? size : maxSize);
        if (image == null) {
            image = this.getInitialsImage(user);
        }
        if (image == null) {
            image = this.getDefaultImage();
        }
        return image;
    }

    public ProfileImageSource getProfileImageSource(String imageSourceStr) {
        ProfileImageSource profileImageSource;
        block3: {
            profileImageSource = null;
            try {
                if (StringUtils.isNotEmpty((CharSequence)imageSourceStr)) {
                    profileImageSource = ProfileImageSource.valueOf(imageSourceStr.toUpperCase());
                }
            }
            catch (IllegalArgumentException e) {
                if (!this.getLogger().isWarnEnabled()) break block3;
                this.getLogger().warn("Unknown profile image source " + imageSourceStr + ".", (Throwable)e);
            }
        }
        return profileImageSource;
    }

    protected Map<String, Object> _extractSourceParameters(UserIdentity user, ProfileImageSource profileImageSource) {
        Request request = ContextHelper.getRequest((Context)this._context);
        switch (profileImageSource.ordinal()) {
            case 3: {
                return this._extractUploadParameters(request, user);
            }
            case 0: {
                return this._extractLocalImageParameters(request, user);
            }
            case 4: {
                return this._extractBase64Parameters(request, user);
            }
            case 1: 
            case 2: {
                return new HashMap<String, Object>();
            }
        }
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn(String.format("Cannot extract image source parameters for user '%s'. Unhandled profile image source '%s'", new Object[]{user, profileImageSource}));
        }
        return null;
    }

    protected Map<String, Object> _extractUploadParameters(Request request, UserIdentity user) {
        String uploadId = request.getParameter("id");
        if (StringUtils.isEmpty((CharSequence)uploadId)) {
            this.getLogger().error("Missing mandatory uploaded file id parameter to retrieve the uploaded file for user " + String.valueOf(user) + ".");
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", uploadId);
        return params;
    }

    protected Map<String, Object> _extractLocalImageParameters(Request request, UserIdentity user) {
        String localFileId = request.getParameter("id");
        if (StringUtils.isEmpty((CharSequence)localFileId)) {
            this.getLogger().error("Missing mandatory local file id parameter to retrieve the local file for user " + String.valueOf(user) + ".");
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", localFileId);
        return params;
    }

    protected Map<String, Object> _extractBase64Parameters(Request request, UserIdentity user) {
        Map<String, Object> rawUserPrefImage = this._getRawUserPrefImage(user);
        if (rawUserPrefImage != null) {
            return rawUserPrefImage;
        }
        String data = request.getParameter("data");
        if (StringUtils.isEmpty((CharSequence)data)) {
            this.getLogger().error("Missing mandatory data parameter for user image of type base 64 user " + String.valueOf(user) + ".");
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", data);
        String filename = request.getParameter("filename");
        if (StringUtils.isNotEmpty((CharSequence)filename)) {
            params.put("filename", filename);
        }
        return params;
    }

    public User.UserImage getImage(ProfileImageSource source, UserIdentity user, Map<String, Object> sourceParams) {
        switch (source.ordinal()) {
            case 1: {
                return this.getGravatarImage(user, this._getImageSize(sourceParams));
            }
            case 3: {
                return this.getUploadedImage(user, (String)sourceParams.get("id"), this._getImageSize(sourceParams));
            }
            case 0: {
                return this.getLocalImage(user, (String)sourceParams.get("id"));
            }
            case 2: {
                return this.getInitialsImage(user);
            }
            case 4: {
                return this.getBase64Image(user, (String)sourceParams.get("data"), (String)sourceParams.get("filename"), (Long)sourceParams.get("lastmodified"));
            }
        }
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn(String.format("Cannot get image for user '%s'. Unhandled profile image source '%s'", new Object[]{user, source}));
        }
        return null;
    }

    public User.UserImage getBase64Image(UserIdentity user, String data, String filename, Long lastModified) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(String.format("No data provided. Unable to retrieve the base64 image for user '%s'.", user));
            }
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(new Base64(true).decode(data));
        return new User.UserImage(is, (String)StringUtils.defaultIfBlank((CharSequence)filename, null), Long.valueOf(is.available()), lastModified, ProfileImageSource.BASE64.toString());
    }

    private Map<String, Object> _getRawUserPrefImage(UserIdentity user) {
        try {
            Map<String, Object> rawUserPref;
            String userPrefImgJson = this._userPrefManager.getUserPreferenceAsString(user, "", Collections.EMPTY_MAP, "profile-image");
            if (StringUtils.isNotEmpty((CharSequence)userPrefImgJson) && (rawUserPref = this._jsonUtils.convertJsonToMap(userPrefImgJson)).containsKey("parameters") && rawUserPref.get("parameters") instanceof Map) {
                return (Map)rawUserPref.get("parameters");
            }
        }
        catch (Exception e) {
            this.getLogger().error(String.format("Unable to retrieve the '%s' userpref for user '%s'", "profile-image", user), (Throwable)e);
        }
        return null;
    }

    private Integer _getImageSize(Map<String, Object> sourceParams) {
        Integer size = (Integer)sourceParams.get("size");
        if (size != null && size > 0) {
            return size;
        }
        Integer maxSize = (Integer)sourceParams.get("maxSize");
        if (maxSize != null && maxSize > 0) {
            return maxSize;
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public User.UserImage getUploadedImage(UserIdentity user, String uploadId, Integer size) {
        if (StringUtils.isEmpty((CharSequence)uploadId)) {
            return null;
        }
        Upload upload = null;
        try {
            upload = this._uploadManager.getUpload(user, uploadId);
            try (InputStream is = upload.getInputStream();){
                User.UserImage userImage;
                String filename = upload.getFilename();
                String format = FilenameUtils.getExtension((String)filename);
                format = AbstractImageReader.ALLOWED_IMG_FORMATS.contains(format) ? format : "png";
                int cropSize = size != null && size > 0 ? size : 256;
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    ImageHelper.generateThumbnail(is, baos, format, 0, 0, 0, 0, cropSize, cropSize);
                    userImage = new User.UserImage(new ByteArrayInputStream(baos.toByteArray()), filename, null, upload.getUploadedDate().toInstant().toEpochMilli(), ProfileImageSource.UPLOAD.toString());
                }
                return userImage;
            }
            catch (IOException e) {
                this.getLogger().error(String.format("Unable to provide the uploaded cropped image for user '%s'and upload id '%s'.", user, uploadId), (Throwable)e);
            }
        }
        catch (NoSuchElementException e) {
            this.getLogger().error(String.format("Cannot find the temporary uploaded file for id '%s' and login '%s'.", uploadId, user), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLocalImage(String localFileId) {
        Source imgSource = null;
        try {
            imgSource = this._getLocalImageSource(localFileId);
            if (imgSource == null) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn(String.format("Unable to test the local image for id '%s.", localFileId));
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = imgSource.exists();
            return bl;
        }
        catch (IOException e) {
            this.getLogger().error(String.format("Unable to  test the local image for id '%s' and login '%s'.", localFileId), (Throwable)e);
        }
        finally {
            if (imgSource != null) {
                this._sourceResolver.release(imgSource);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User.UserImage getLocalImage(UserIdentity user, String localFileId) {
        Source imgSource = null;
        try {
            imgSource = this._getLocalImageSource(localFileId);
            if (imgSource == null) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn(String.format("Unable to retrieve the local image for id '%s' and login '%s'.", localFileId, user));
                }
                User.UserImage userImage = null;
                return userImage;
            }
            if (imgSource.exists()) {
                String avatarPath = this._getLocalImagePaths().get(localFileId);
                User.UserImage userImage = new User.UserImage(imgSource.getInputStream(), FilenameUtils.getName((String)avatarPath), null, imgSource.getLastModified(), String.valueOf((Object)ProfileImageSource.LOCALIMAGE) + "-" + localFileId);
                return userImage;
            }
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(String.format("Unable to find any local image with id '%s' for user '%s'", localFileId, user));
            }
        }
        catch (IOException e) {
            this.getLogger().error(String.format("Unable to retrieve the local image for id '%s' and login '%s'.", localFileId, user), (Throwable)e);
        }
        finally {
            if (imgSource != null) {
                this._sourceResolver.release(imgSource);
            }
        }
        return null;
    }

    protected Source _getLocalImageSource(String localFileId) throws IOException {
        String avatarPath;
        Map<String, String> imgPaths = this._getLocalImagePaths();
        String string = avatarPath = imgPaths != null ? imgPaths.get(localFileId) : "";
        if (StringUtils.isEmpty((CharSequence)avatarPath)) {
            return null;
        }
        String location = "plugin:core-ui://resources/img/user-profiles/avatar/" + avatarPath;
        return this._sourceResolver.resolveURI(location);
    }

    public List<String> getLocalImageIds() {
        return new LinkedList<String>(this._getLocalImagePaths().keySet());
    }

    protected Map<String, String> _getLocalImagePaths() {
        this._initializeLocalImagePaths();
        return __avatarPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initializeLocalImagePaths() {
        Class<DefaultProfileImageProvider> clazz = DefaultProfileImageProvider.class;
        synchronized (DefaultProfileImageProvider.class) {
            if (__avatarPaths == null) {
                __avatarPaths = new LinkedHashMap<String, String>();
                String location = "plugin:core-ui://resources/img/user-profiles/avatar/avatar.xml";
                Source source = null;
                try {
                    source = this._sourceResolver.resolveURI(location);
                    try (InputStream is = source.getInputStream();){
                        Configuration cfg = new DefaultConfigurationBuilder().build(is);
                        for (Configuration imageCfg : cfg.getChildren("image")) {
                            __avatarPaths.put(imageCfg.getAttribute("id"), imageCfg.getValue());
                        }
                    }
                }
                catch (IOException | ConfigurationException | SAXException e) {
                    this.getLogger().error("Unable to retrieve the map of local image paths", e);
                }
                finally {
                    if (source != null) {
                        this._sourceResolver.release(source);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasInitialsImage(UserIdentity userIdentity) {
        User user = this._userManager.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
        if (user == null) {
            this.getLogger().warn("Unable to test the initials image - user not found " + String.valueOf(userIdentity));
            return false;
        }
        String initial = user.getFullName().substring(0, 1).toLowerCase();
        Source imgSource = null;
        try {
            imgSource = this._getInitialsImageSource(initial);
            boolean bl = imgSource.exists();
            return bl;
        }
        catch (IOException e) {
            this.getLogger().error(String.format("Unable to test initials image for user '%s' with fullname '%s'.", userIdentity, user.getFullName()), (Throwable)e);
        }
        finally {
            if (imgSource != null) {
                this._sourceResolver.release(imgSource);
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public User.UserImage getInitialsImage(UserIdentity userIdentity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 14[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Source _getInitialsImageSource(String initial) throws IOException {
        String location = "plugin:core-ui://resources/img/user-profiles/initials/" + initial + ".png";
        return this._sourceResolver.resolveURI(location);
    }

    protected InputStream _addImageBackground(UserIdentity user, InputStream is) throws IOException {
        BufferedImage image = ImageIO.read(is);
        Source bgSource = null;
        try {
            ByteArrayInputStream byteArrayInputStream;
            bgSource = this._getInitialsBackgroundSource(user);
            BufferedImage background = null;
            try (InputStream backgroundIs = bgSource.getInputStream();){
                background = ImageIO.read(backgroundIs);
                Graphics backgroundGraphics = background.getGraphics();
                backgroundGraphics.drawImage(image, 0, 0, null);
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)background, "png", baos);
                byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            }
            return byteArrayInputStream;
        }
        finally {
            this._sourceResolver.release(bgSource);
        }
    }

    protected Source _getInitialsBackgroundSource(UserIdentity user) throws IOException {
        long hash = Math.abs(HashUtil.hash((String)user.getLogin()));
        this._initializeInitialsBackgroundPaths();
        long nbBackground = __initialsBgPaths.size();
        if (nbBackground == 0L) {
            throw new IOException("No backgrounds available.");
        }
        int indexBackground = (int)(hash % nbBackground);
        String path = __initialsBgPaths.get(indexBackground);
        String location = "plugin:core-ui://resources/img/user-profiles/initials/" + path;
        return this._sourceResolver.resolveURI(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initializeInitialsBackgroundPaths() {
        Class<DefaultProfileImageProvider> clazz = DefaultProfileImageProvider.class;
        synchronized (DefaultProfileImageProvider.class) {
            if (__initialsBgPaths == null) {
                __initialsBgPaths = new LinkedList<String>();
                String location = "plugin:core-ui://resources/img/user-profiles/initials/initials.xml";
                Source source = null;
                try {
                    source = this._sourceResolver.resolveURI(location);
                    try (InputStream is = source.getInputStream();){
                        Configuration cfg = new DefaultConfigurationBuilder().build(is);
                        for (Configuration backgroundCfg : cfg.getChildren("background")) {
                            __initialsBgPaths.add(backgroundCfg.getValue());
                        }
                    }
                }
                catch (IOException | ConfigurationException | SAXException e) {
                    this.getLogger().error("Unable to retrieve the list of available backgrounds for initials images", e);
                }
                finally {
                    if (source != null) {
                        this._sourceResolver.release(source);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static enum ProfileImageSource {
        LOCALIMAGE,
        GRAVATAR,
        INITIALS,
        UPLOAD,
        BASE64;

    }
}

