/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.user;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class EditProfileImageClientSideElement
extends StaticClientSideElement {
    public static final String UD_DATA_PROVIDER_ID = "org.ametys.plugins.userdirectory.userdataprovider.ContentUserDataProvider";
    private UserManager _userManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
    }

    @Override
    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        ArrayList<ClientSideElement.Script> clonedScripts = new ArrayList<ClientSideElement.Script>();
        List<ClientSideElement.Script> scripts = super.getScripts(ignoreRights, contextParameters);
        for (ClientSideElement.Script script : scripts) {
            ClientSideElement.Script clonedScript = new ClientSideElement.Script(script);
            if (!this.isEditAvailable()) {
                clonedScript.getParameters().put("disabled", true);
                Object disabledDesc = clonedScript.getParameters().get("disabled-description");
                clonedScript.getParameters().put("description", disabledDesc);
            }
            clonedScripts.add(clonedScript);
        }
        return clonedScripts;
    }

    @Callable(rights={"*"})
    public boolean isEditAvailable() {
        User user;
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        if (userIdentity != null && (user = this._userManager.getUser(userIdentity)) != null) {
            return !UD_DATA_PROVIDER_ID.equals(user.getProviderFor("image").getClass().getName());
        }
        return false;
    }
}

