/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.user;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.AmetysXSLTHelper;
import org.ametys.core.util.ImageResolverHelper;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.core.ui.user.DefaultUserImageHelper;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.excalibur.source.SourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileImageResolverHelper
implements Serviceable,
Contextualizable,
Initializable {
    protected static SourceResolver _srcResolver;
    protected static Context _context;
    private static final Logger __LOGGER;
    private static ProfileImageResolverHelper _instance;
    private DefaultUserImageHelper _defaultUserImageHelper;
    private UserManager _userManager;

    public void service(ServiceManager manager) throws ServiceException {
        _srcResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._defaultUserImageHelper = (DefaultUserImageHelper)manager.lookup(DefaultUserImageHelper.ROLE);
    }

    public void initialize() throws Exception {
        _instance = this;
    }

    public void contextualize(Context context) throws ContextException {
        _context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User.UserImage getProfileImage(String login, String populationId, int size, String lang) {
        UserIdentity userIdentity = new UserIdentity(login, populationId);
        User user = this._userManager.getUser(userIdentity);
        User.UserImage image = null;
        if (user != null) {
            Request request = ContextHelper.getRequest((Context)_context);
            Object langAttribute = request.getAttribute("lang");
            try {
                request.setAttribute("lang", (Object)lang);
                image = user.getImage(size, size);
            }
            finally {
                request.setAttribute("lang", langAttribute);
            }
        } else {
            image = this._defaultUserImageHelper.getDefaultImage();
        }
        return image;
    }

    public String getProfileImageUri(String login, String populationId, int size) {
        return "/core-ui/user/" + populationId + "/" + login + "/image_" + size;
    }

    public static String resolve(String login, String populationId, int size, String lang) {
        return ProfileImageResolverHelper.resolve(login, populationId, size, lang, false);
    }

    public static String resolve(String login, String populationId, int size, String lang, boolean absolute) {
        return ProfileImageResolverHelper.resolve(login, populationId, size, lang, absolute, false);
    }

    public static String resolve(String login, String populationId, int size, String lang, boolean absolute, boolean internal) {
        String path = _instance.getProfileImageUri(login, populationId, size);
        HashMap<String, String> params = new HashMap<String, String>();
        if (lang != null) {
            params.put("lang", lang);
        }
        String resultUri = _instance.getUri(path, absolute, internal);
        return internal ? URIUtils.buildURI(resultUri, params) : URIUtils.encodeURI(resultUri, params);
    }

    public static String resolveAsBase64(String login, String populationId, int cropSize, String lang) {
        try {
            User.UserImage userImage = _instance.getProfileImage(login, populationId, cropSize, lang);
            InputStream dataIs = userImage.getInputstream();
            if (dataIs != null) {
                return ImageResolverHelper.resolveImageAsBase64(dataIs, "image/png", 0, 0, 0, 0, cropSize, cropSize);
            }
            userImage.close();
        }
        catch (IOException e) {
            __LOGGER.error("Failed to retrieve profile image as Base64 for user " + login + "/" + populationId, (Throwable)e);
        }
        return "";
    }

    protected String getUri(String path, boolean absolute, boolean internal) {
        String fullPath = "/plugins" + path;
        if (internal) {
            return "cocoon://_plugins" + path;
        }
        if (absolute) {
            return AmetysXSLTHelper.uriPrefix(true) + fullPath;
        }
        return AmetysXSLTHelper.absoluteUriPrefix(true) + fullPath;
    }

    static {
        __LOGGER = LoggerFactory.getLogger((String)ProfileImageResolverHelper.class.getName());
    }
}

