/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.user;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.core.ui.user.DefaultProfileImageProvider;
import org.ametys.plugins.core.ui.user.DefaultUserImageHelper;
import org.ametys.plugins.core.ui.user.ProfileImageProvider;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;

public class SafeProfileImageProvider
extends AbstractLogEnabled
implements ProfileImageProvider,
Serviceable,
Component {
    protected SourceResolver _sourceResolver;
    protected UserManager _userManager;
    protected DefaultUserImageHelper _defaultUserImageHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        this._sourceResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._defaultUserImageHelper = (DefaultUserImageHelper)smanager.lookup(DefaultUserImageHelper.ROLE);
    }

    @Override
    public User.UserImage getDefaultImageForUser(UserIdentity user, int size, int maxSize) {
        return this.getImage(user, "", size, maxSize, null);
    }

    @Override
    public User.UserImage getImage(UserIdentity user, String imageSource, int size, int maxSize, Map<String, Object> userPrefSourceParameters) {
        User.UserImage image = this.getGravatarImage(user, size > 0 ? size : maxSize);
        return image == null ? this.getDefaultImage() : image;
    }

    protected User.UserImage getDefaultImage() {
        return this._defaultUserImageHelper.getDefaultImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User.UserImage getGravatarImage(UserIdentity user, int size) {
        Config config = Config.getInstance();
        if (config == null || !config.getValue("runtime.userprofile.imagesource.gravatar", false, false).booleanValue()) {
            return null;
        }
        Source httpSource = null;
        try {
            httpSource = this._getGravatarImageSource(user, size);
            if (httpSource != null && httpSource.exists()) {
                User.UserImage userImage = new User.UserImage(httpSource.getInputStream(), null, null, httpSource.getLastModified(), DefaultProfileImageProvider.ProfileImageSource.GRAVATAR.toString());
                return userImage;
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to retrieve gravatar image for user '" + String.valueOf(user) + "'.", (Throwable)e);
        }
        finally {
            if (httpSource != null) {
                this._sourceResolver.release(httpSource);
            }
        }
        return null;
    }

    private Source _getGravatarImageSource(UserIdentity userIdentity, Integer size) throws IOException {
        User user = this._userManager.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
        if (user == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Unable to get gravatar image source - user not found " + String.valueOf(userIdentity));
            }
            return null;
        }
        String email = user.getEmail();
        if (StringUtils.isEmpty((CharSequence)email)) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info(String.format("Unable to get gravatar image for user '%s' - an email is mandatory", userIdentity));
            }
            return null;
        }
        String hash = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(StandardCharsets.UTF_8.encode(email));
            byte[] hexBytes = new Hex(StandardCharsets.UTF_8).encode(md5.digest());
            hash = new String(hexBytes, StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().error("Cannot encode the user email to md5Base64", (Throwable)e);
            return null;
        }
        ArrayList<BasicNameValuePair> qparams = new ArrayList<BasicNameValuePair>(1);
        qparams.add(new BasicNameValuePair("d", "404"));
        if (size != null && size > 0) {
            qparams.add(new BasicNameValuePair("s", Integer.toString(size)));
        }
        String uri = new URIBuilder().setScheme("https").setHost("www.gravatar.com").setPath("/avatar/" + hash + ".png").setParameters(qparams).toString();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Build gravatar uri for user '%s' : %s", userIdentity, uri));
        }
        return this._sourceResolver.resolveURI(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasGravatarImage(UserIdentity user) {
        Config config = Config.getInstance();
        if (config == null || !config.getValue("runtime.userprofile.imagesource.gravatar", false, false).booleanValue()) {
            return false;
        }
        Source httpSource = null;
        try {
            httpSource = this._getGravatarImageSource(user, null);
            boolean bl = httpSource != null && httpSource.exists();
            return bl;
        }
        catch (IOException e) {
            this.getLogger().error("Unable to test the gravatar image for user '" + String.valueOf(user) + "'.", (Throwable)e);
        }
        finally {
            if (httpSource != null) {
                this._sourceResolver.release(httpSource);
            }
        }
        return false;
    }
}

