/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.user;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreference;
import org.ametys.core.util.ImageHelper;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.ui.user.AbstractImageReader;
import org.ametys.plugins.core.ui.user.DefaultProfileImageProvider;
import org.ametys.plugins.core.ui.user.ProfileImageProvider;
import org.ametys.plugins.core.userpref.SetUserPreferencesAction;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class SetUserProfileAction
extends SetUserPreferencesAction {
    public static final String USERPREF_PROFILE_IMAGE = "profile-image";
    protected JSONUtils _jsonUtils;
    protected DefaultProfileImageProvider _profileImageProvider;
    protected UploadManager _uploadManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
    }

    @Override
    protected Map<String, Object> _getTypedValues(Request request, Collection<UserPreference> userPreferences, UserIdentity user, Collection<String> preferenceIds) {
        Map<String, Object> preferences;
        String userPrefImageJson;
        if (this._profileImageProvider == null) {
            try {
                this._uploadManager = (UploadManager)this.manager.lookup(UploadManager.ROLE);
                this._profileImageProvider = (DefaultProfileImageProvider)this.manager.lookup(ProfileImageProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException("Lazy initialization failed.", e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(userPrefImageJson = (String)(preferences = super._getTypedValues(request, userPreferences, user, preferenceIds)).get(USERPREF_PROFILE_IMAGE)))) {
            Map<String, Object> userPrefImage = null;
            try {
                userPrefImage = this._jsonUtils.convertJsonToMap(userPrefImageJson);
            }
            catch (Exception e) {
                this.getLogger().error(String.format("Unable to extract image user pref for user '%s'.", user), (Throwable)e);
            }
            if (userPrefImage != null) {
                DefaultProfileImageProvider.ProfileImageSource profileImageSource = this._profileImageProvider.getProfileImageSource((String)userPrefImage.get("source"));
                if (DefaultProfileImageProvider.ProfileImageSource.BASE64.equals((Object)profileImageSource)) {
                    preferences.remove(USERPREF_PROFILE_IMAGE);
                } else if (DefaultProfileImageProvider.ProfileImageSource.UPLOAD.equals((Object)profileImageSource)) {
                    Map sourceParams = (Map)userPrefImage.get("parameters");
                    String uploadId = sourceParams != null ? (String)sourceParams.get("id") : null;
                    HashMap<String, Object> base64SourceParams = null;
                    if (StringUtils.isNotEmpty((CharSequence)uploadId)) {
                        Upload upload = null;
                        try {
                            upload = this._uploadManager.getUpload(user, uploadId);
                            base64SourceParams = new HashMap<String, Object>();
                            try (InputStream is = upload.getInputStream();){
                                String filename = upload.getFilename();
                                base64SourceParams.put("data", this._convertFile(filename, is));
                                base64SourceParams.put("filename", filename);
                                base64SourceParams.put("lastmodified", upload.getUploadedDate().toInstant().toEpochMilli());
                            }
                            catch (IOException e) {
                                base64SourceParams = null;
                                this.getLogger().error(String.format("Unable to store the profile image user pref for user '%s'. Error while trying to convert the uploaded file '%s' to base64.", user, uploadId), (Throwable)e);
                            }
                        }
                        catch (NoSuchElementException e) {
                            this.getLogger().error(String.format("Cannot find the temporary uploaded file for id '%s' and login '%s'.", uploadId, user), (Throwable)e);
                        }
                    }
                    if (base64SourceParams != null) {
                        HashMap<String, Object> base64UserPrefImage = new HashMap<String, Object>();
                        base64UserPrefImage.put("source", DefaultProfileImageProvider.ProfileImageSource.BASE64.name().toLowerCase());
                        base64UserPrefImage.put("parameters", base64SourceParams);
                        preferences.put(USERPREF_PROFILE_IMAGE, this._jsonUtils.convertObjectToJson(base64UserPrefImage));
                    } else {
                        preferences.remove(USERPREF_PROFILE_IMAGE);
                    }
                }
            }
        }
        return preferences;
    }

    protected String _convertFile(String filename, InputStream is) throws IOException {
        String format = FilenameUtils.getExtension((String)filename);
        format = AbstractImageReader.ALLOWED_IMG_FORMATS.contains(format) ? format : "png";
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageHelper.generateThumbnail(is, baos, format, 0, 0, 0, 0, 256, 256);
            String string = Base64.encodeBase64URLSafeString((byte[])baos.toByteArray());
            return string;
        }
    }
}

