/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.user;

import org.ametys.core.user.User;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.core.ui.user.AbstractImageReader;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;

public class UserImageReader
extends AbstractImageReader {
    private UserManager _userManager;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userManager = (UserManager)this.manager.lookup(UserManager.ROLE);
    }

    @Override
    protected void initImage() throws ProcessingException {
        this._size = this.parameters.getParameterAsInteger("size", 0);
        this._maxSize = this.parameters.getParameterAsInteger("maxSize", 0);
        User user = this._userManager.getUser(this._user);
        this._image = user != null ? user.getImage(this._size, this._maxSize) : this._defaultUserImageHelper.getDefaultImage();
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public SourceValidity getValidity() {
        Long lastModifiedLong = this._image.getLastModified();
        long lastModified = lastModifiedLong != null ? lastModifiedLong : 0L;
        return new TimeStampValidity(lastModified);
    }
}

