/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class RequestAttributesHelper
implements Component,
Contextualizable {
    public static final String ROLE = RequestAttributesHelper.class.getName();
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public Map<String, Object> saveRequestAttributes() {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        Request request = ContextHelper.getRequest((Context)this._context);
        Enumeration attrNames = request.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            Object value = request.getAttribute(attrName);
            attrs.put(attrName, value);
        }
        return attrs;
    }

    public void restoreRequestAttributes(Map<String, Object> attributes) {
        this.removeRequestAttributes();
        Request request = ContextHelper.getRequest((Context)this._context);
        for (String attrName : attributes.keySet()) {
            request.setAttribute(attrName, attributes.get(attrName));
        }
    }

    public void removeRequestAttributes() {
        Request request = ContextHelper.getRequest((Context)this._context);
        ArrayList<String> attrNames = Collections.list(request.getAttributeNames());
        for (String attrName : attrNames) {
            if (this._isADispatchableCache(attrName, request)) continue;
            request.removeAttribute(attrName);
        }
    }

    private boolean _isADispatchableCache(String attrName, Request request) {
        Object attribute = request.getAttribute(attrName);
        return attribute instanceof Cache && attrName.startsWith(AbstractCacheManager.ROLE) && ((Cache)attribute).isDispatchable();
    }
}

