/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.util.cocoon.AbstractCurrentUserProviderServiceableAction;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.cocoon.servlet.multipart.RejectedPart;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class UploadAction
extends AbstractCurrentUserProviderServiceableAction {
    protected UploadManager _uploadManager;

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        this._lookupComponents();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this._doUpload(request, parameters, result);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected void _lookupComponents() throws ServiceException {
        if (this._uploadManager == null) {
            this._uploadManager = (UploadManager)this.manager.lookup(UploadManager.ROLE);
        }
    }

    protected void _doUpload(Request request, Parameters parameters, Map<String, Object> result) throws Exception {
        Part partUploaded = this._getPart(request);
        if (!(partUploaded instanceof PartOnDisk)) {
            RejectedPart rejectedPart;
            result.put("success", false);
            if (partUploaded instanceof RejectedPart && (rejectedPart = (RejectedPart)partUploaded).getMaxContentLength() == 0) {
                result.put("error", "infected");
            } else {
                result.put("error", "rejected");
            }
        } else {
            try (InputStream is = partUploaded.getInputStream();){
                this._storeUpload(is, partUploaded.getFileName(), result);
            }
            catch (IOException e) {
                this._handleStoreUploadException(e, partUploaded, result);
            }
        }
    }

    protected Part _getPart(Request request) throws Exception {
        Part partUploaded = (Part)request.get("file");
        if (partUploaded == null) {
            throw new Exception("Missing request parameter file");
        }
        return partUploaded;
    }

    protected void _storeUpload(InputStream is, String filename, Map<String, Object> result) throws IOException {
        Upload upload = this._uploadManager.storeUpload(this._getCurrentUser(), filename, is);
        this._fillSuccess(upload, result);
    }

    protected void _fillSuccess(Upload upload, Map<String, Object> result) {
        result.put("success", true);
        result.put("id", upload.getId());
        result.put("filename", upload.getFilename());
        result.put("size", upload.getLength());
        result.put("viewHref", this._getUrlForView(upload));
        result.put("downloadHref", this._getUrlForDownload(upload));
    }

    protected void _handleStoreUploadException(IOException e, Object obj, Map<String, Object> result) {
        this.getLogger().error("Unable to store uploaded file: " + String.valueOf(obj), (Throwable)e);
        result.put("success", false);
        HashMap<String, String> ex = new HashMap<String, String>();
        ex.put("message", e.getMessage());
        ex.put("stacktrace", ExceptionUtils.getStackTrace((Throwable)e));
        result.put("error", ex);
    }

    protected String _getUrlForView(Upload upload) {
        return "/plugins/core/upload/file?id=" + upload.getId();
    }

    protected String _getUrlForDownload(Upload upload) {
        return "/plugins/core/upload/file?id=" + upload.getId() + "&download=true";
    }
}

