/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.NoSuchElementException;
import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.cocoon.AbstractResourceReader;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.xml.sax.SAXException;

public class UploadReader
extends AbstractResourceReader
implements Serviceable {
    private CurrentUserProvider _currentUserProvider;
    private UploadManager _uploadManager;
    private Upload _upload;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._uploadManager = (UploadManager)serviceManager.lookup(UploadManager.ROLE);
    }

    @Override
    protected void doSetup(SourceResolver res, Map objModel, String src, Parameters par) {
        Request request = ObjectModelHelper.getRequest((Map)objModel);
        String uploadId = request.getParameter("id");
        try {
            this._upload = this._uploadManager.getUpload(this._currentUserProvider.getUser(), uploadId);
        }
        catch (NoSuchElementException e) {
            this.getLogger().warn("Cannot find the temporary uploaded file with id " + (String)(uploadId != null ? "'" + uploadId + "'" : "<null>"));
        }
    }

    @Override
    protected InputStream getInputStream() {
        return this._upload.getInputStream();
    }

    @Override
    protected String getFilename() {
        return this._upload.getFilename();
    }

    @Override
    protected String getEncodedFilename() {
        return null;
    }

    @Override
    protected long getLength() {
        return this._upload.getLength();
    }

    public long getLastModified() {
        if (this._upload != null) {
            return this._upload.getUploadedDate().toInstant().toEpochMilli();
        }
        return super.getLastModified();
    }

    public String getMimeType() {
        if (this._upload != null) {
            return this._upload.getMimeType();
        }
        return super.getMimeType();
    }

    @Override
    public void generate() throws IOException, SAXException, ProcessingException {
        if (this._upload == null) {
            throw new ResourceNotFoundException("No upload for source: " + this.source);
        }
        super.generate();
    }

    public void recycle() {
        super.recycle();
        this._upload = null;
    }
}

