/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.upload.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import org.ametys.core.upload.Upload;
import org.ametys.core.util.ImageHelper;
import org.ametys.plugins.core.upload.UploadAction;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.Request;
import org.apache.commons.io.FilenameUtils;

public class CropImageAction
extends UploadAction {
    @Override
    protected void _doUpload(Request request, Parameters parameters, Map<String, Object> result) throws Exception {
        Upload originalImage = this._getUploadObject(request, parameters);
        Cropping cropping = new Cropping(parameters);
        this._doCrop(originalImage, cropping, result);
    }

    protected Upload _getUploadObject(Request request, Parameters parameters) throws ParameterException {
        String imageId = parameters.getParameter("imageId");
        return this._uploadManager.getUpload(this._getCurrentUser(), imageId);
    }

    protected void _doCrop(Upload originalImage, Cropping cropping, Map<String, Object> result) throws IOException {
        if (cropping.isOriginal()) {
            this._fillSuccess(originalImage, result);
            return;
        }
        try (InputStream is = originalImage.getInputStream();){
            BufferedImage src = this._uploadAsBufferedImage(originalImage);
            int originalWidth = src.getWidth();
            int originalHeight = src.getHeight();
            int x = cropping.getX(originalWidth);
            int y = cropping.getY(originalHeight);
            int width = cropping.getWidth(originalWidth);
            width = this._checkValidity(width, x, originalWidth);
            int height = cropping.getHeight(originalHeight);
            height = this._checkValidity(height, y, originalHeight);
            BufferedImage croppedImage = ImageHelper.generateCroppedImage(src, x, y, height, width);
            this._storeCroppedImage(croppedImage, originalImage.getFilename(), result);
        }
    }

    private int _checkValidity(int widthOrHeight, int xOrY, int originalWidthOrHeight) {
        if (xOrY + widthOrHeight > originalWidthOrHeight) {
            return originalWidthOrHeight - xOrY;
        }
        return widthOrHeight;
    }

    protected BufferedImage _uploadAsBufferedImage(Upload upload) throws IOException {
        try (InputStream is = upload.getInputStream();){
            BufferedImage bufferedImage = ImageHelper.read(is);
            return bufferedImage;
        }
    }

    protected void _storeCroppedImage(BufferedImage croppedImage, String originalName, Map<String, Object> result) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)croppedImage, this._getFormatName(originalName), baos);
            byte[] buffer = baos.toByteArray();
            try (ByteArrayInputStream is = new ByteArrayInputStream(buffer);){
                this._storeUpload(is, this._getCroppedImageFilename(originalName), result);
            }
            catch (IOException e) {
                this._handleStoreUploadException(e, croppedImage, result);
            }
        }
    }

    protected String _getFormatName(String iamgeFilename) {
        String format = FilenameUtils.getExtension((String)iamgeFilename);
        return format.isEmpty() ? "png" : format;
    }

    protected String _getCroppedImageFilename(String originalName) {
        return originalName;
    }

    protected static class Cropping {
        private float _relativeX1;
        private float _relativeY1;
        private float _relativeWidth;
        private float _relativeHeight;

        protected Cropping(Parameters parameters) {
            this._relativeX1 = parameters.getParameterAsFloat("x1", 0.0f);
            this._relativeY1 = parameters.getParameterAsFloat("y1", 0.0f);
            this._relativeWidth = parameters.getParameterAsFloat("width", 1.0f);
            this._relativeHeight = parameters.getParameterAsFloat("height", 1.0f);
            assert (this._relativeX1 >= 0.0f);
            assert (this._relativeX1 <= 1.0f);
            assert (this._relativeY1 >= 0.0f);
            assert (this._relativeY1 <= 1.0f);
            assert (this._relativeWidth >= 0.0f);
            assert (this._relativeWidth <= 1.0f);
            assert (this._relativeHeight >= 0.0f);
            assert (this._relativeHeight <= 1.0f);
        }

        protected boolean isOriginal() {
            return this._relativeX1 <= 0.0f && this._relativeY1 <= 0.0f && this._relativeWidth >= 1.0f && this._relativeHeight >= 1.0f;
        }

        protected int getX(int originalWidth) {
            return Math.round((float)originalWidth * this._relativeX1);
        }

        protected int getY(int originalHeight) {
            return Math.round((float)originalHeight * this._relativeY1);
        }

        protected int getWidth(int originalWidth) {
            return Math.round((float)originalWidth * this._relativeWidth);
        }

        protected int getHeight(int originalHeight) {
            return Math.round((float)originalHeight * this._relativeHeight);
        }
    }
}

