/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.authentication.AbstractCredentialProvider;
import org.ametys.core.authentication.AuthenticateAction;
import org.ametys.core.authentication.BlockingCredentialProvider;
import org.ametys.core.group.GroupManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.InvalidModificationException;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.ModifiableUserDirectory;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.core.impl.user.directory.JdbcUserDirectory;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class UserDAO
extends AbstractLogEnabled
implements Component,
Contextualizable,
Serviceable {
    public static final String ROLE = UserDAO.class.getName();
    public static final String RIGHT_LIST_USERS = "Runtime_Rights_ListUsers";
    private static final int _DEFAULT_USER_SEARCH_COUNT_VALUE = 100;
    private static final int _DEFAULT_USER_SEARCH_OFFSET_VALUE = 0;
    protected ServiceManager _smanager;
    protected UserManager _userManager;
    protected UserPopulationDAO _userPopulationDAO;
    protected PopulationContextHelper _populationContextHelper;
    protected CurrentUserProvider _currentUserProvider;
    protected Context _context;
    protected UserHelper _userHelper;
    protected RightManager _rightManager;
    protected GroupManager _groupManager;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager smanager) throws ServiceException {
        this._smanager = smanager;
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)smanager.lookup(UserPopulationDAO.ROLE);
        this._populationContextHelper = (PopulationContextHelper)smanager.lookup(PopulationContextHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
        this._groupManager = (GroupManager)smanager.lookup(GroupManager.ROLE);
    }

    @Callable(rights={"Runtime_Rights_ListUsers"})
    public List<Map<String, Object>> getUsersByUserIdentitiesAndContexts(List<String> userIdentities, List<String> contexts, Boolean limitedToStoredUserData) {
        ArrayList<Map<String, Object>> users = new ArrayList<Map<String, Object>>();
        if (userIdentities != null) {
            for (String value : userIdentities) {
                String login = StringUtils.substringBeforeLast((String)value, (String)"#");
                String populationId = StringUtils.substringAfterLast((String)value, (String)"#");
                List contextsToCheck = contexts;
                Request request = ContextHelper.getRequest((Context)this._context);
                if (contextsToCheck == null && request != null) {
                    contextsToCheck = (List)request.getAttribute("populationContexts");
                }
                this._checkCurrentUserRightToSearch(contextsToCheck, populationId);
                Map<String, Object> userAsJson = this._userHelper.user2json(new UserIdentity(login, populationId), true, limitedToStoredUserData != null ? limitedToStoredUserData : false);
                users.add(userAsJson);
            }
        }
        return users;
    }

    @Callable(rights={"Runtime_Rights_ListUsers"})
    public List<Map<String, Object>> searchUsersByContexts(List<String> contexts, Integer limit, Integer offset, String searchCriteria, Boolean limitedToStoredUserData) {
        Integer limitOrDefault = limit == null ? 100 : (limit == -1 ? Integer.MAX_VALUE : limit);
        Integer offsetOrDefault = offset != null ? offset : 0;
        List contextsToCheck = contexts;
        Request request = ContextHelper.getRequest((Context)this._context);
        if (contextsToCheck == null && request != null) {
            contextsToCheck = (List)request.getAttribute("populationContexts");
        }
        if (contextsToCheck == null) {
            throw new IllegalArgumentException("Context is null and no context can be found in the request");
        }
        List<User> usersByContext = this._userManager.getUsersByContext(new HashSet<String>(contextsToCheck), limitOrDefault, offsetOrDefault, this._getSearchParameters(searchCriteria), true, true);
        return this._userHelper.users2json(usersByContext, true, limitedToStoredUserData != null ? limitedToStoredUserData : false);
    }

    @Callable(rights={"Runtime_Rights_ListUsers"})
    public List<Map<String, Object>> searchUsersByDirectory(String userDirectoryId, String userPopulationId, Integer limit, Integer offset, String searchCriteria, Boolean limitedToStoredUserData) {
        Integer limitOrDefault = limit == null ? 100 : (limit == -1 ? Integer.MAX_VALUE : limit);
        Integer offsetOrDefault = offset != null ? offset : 0;
        Request request = ContextHelper.getRequest((Context)this._context);
        List populationContexts = request != null ? (List)request.getAttribute("populationContexts") : null;
        this._checkCurrentUserRightToSearch(populationContexts, userPopulationId);
        Collection<User> usersByDirectory = this._userManager.getUsersByDirectory(userPopulationId, userDirectoryId, (int)limitOrDefault, (int)offsetOrDefault, this._getSearchParameters(searchCriteria));
        return this._userHelper.users2json(usersByDirectory, true, limitedToStoredUserData != null ? limitedToStoredUserData : false);
    }

    @Callable(rights={"Runtime_Rights_ListUsers"})
    public List<Map<String, Object>> searchUsersByPopulation(String userPopulationId, Integer limit, Integer offset, String searchCriteria, Boolean limitedToStoredUserData) {
        Integer limitOrDefault = limit == null ? 100 : (limit == -1 ? Integer.MAX_VALUE : limit);
        Integer offsetOrDefault = offset != null ? offset : 0;
        Request request = ContextHelper.getRequest((Context)this._context);
        List populationContexts = request != null ? (List)request.getAttribute("populationContexts") : null;
        this._checkCurrentUserRightToSearch(populationContexts, userPopulationId);
        Collection<User> users = this._userManager.getUsers(userPopulationId, (int)limitOrDefault, (int)offsetOrDefault, this._getSearchParameters(searchCriteria), true);
        return this._userHelper.users2json(users, true, limitedToStoredUserData != null ? limitedToStoredUserData : false);
    }

    protected Map<String, Object> _getSearchParameters(String searchCriteria) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pattern", searchCriteria);
        return params;
    }

    private void _checkCurrentUserRightToSearch(List<String> contexts, String populationId) {
        String currentUserPopulationId;
        UserIdentity user = this._currentUserProvider.getUser();
        if (contexts == null || contexts.contains("/admin") ? this._rightManager.currentUserHasRight("Runtime_Rights_Admin_Access", "/admin") != RightManager.RightResult.RIGHT_ALLOW : !(currentUserPopulationId = user.getPopulationId()).equals(populationId) && !this._checkPopulationsInSharedContext(new HashSet<String>(contexts), populationId, currentUserPopulationId)) {
            throw new AccessDeniedException("User " + String.valueOf(user) + " tried to access a list of users without convenient rights");
        }
    }

    private boolean _checkPopulationsInSharedContext(Set<String> contexts, String population1, String population2) {
        Set<String> userPopulationsSharedContexts = this._populationContextHelper.getSharedContextsForUserPopulations(population1, population2);
        if (userPopulationsSharedContexts != null && !userPopulationsSharedContexts.isEmpty()) {
            if (contexts == null) {
                return true;
            }
            for (String context : contexts) {
                if (!userPopulationsSharedContexts.contains(context)) continue;
                return true;
            }
        }
        return false;
    }

    @Callable(rights={""})
    public Map<String, Object> getUser(String login, String populationId) {
        if (!this._canHandle(populationId)) {
            throw new AccessDeniedException("The user " + String.valueOf(this._getCurrentUser()) + " tried to get user without sufficient rights");
        }
        return this._userHelper.user2json(this._userManager.getUser(populationId, login), true);
    }

    @Callable(rights={""})
    public Map<String, Object> getStoredUser(String login, String populationId) {
        if (!this._canHandle(populationId)) {
            throw new AccessDeniedException("The user " + String.valueOf(this._getCurrentUser()) + " tried to get user without sufficient rights");
        }
        return this._userHelper.user2json(this._userManager.getUser(populationId, login), true, true);
    }

    @Callable(rights={""})
    public Map<String, Object> isModifiable(String login, String populationId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isModifiable = this._userManager.getUserDirectory(populationId, login) instanceof ModifiableUserDirectory;
        result.put("isModifiable", isModifiable && this._canHandle(populationId));
        result.put("additionalDescription", new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_USERS_EDIT_NO_MODIFIABLE_DESCRIPTION"));
        return result;
    }

    @Callable(rights={"*"})
    public Map<String, Object> isRemovable(String login, String populationId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        UserDirectory userDirectory = this._userManager.getUserDirectory(populationId, login);
        if (userDirectory != null && populationId.equals("admin_population") && userDirectory.getStoredUsers().size() == 1) {
            result.put("isRemovable", false);
            result.put("additionalDescription", new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_USERS_DELETE_LAST_ADMIN_DESCRIPTION"));
        } else {
            boolean isRemovable = userDirectory instanceof ModifiableUserDirectory;
            result.put("isRemovable", isRemovable && this._canHandle(populationId));
            result.put("additionalDescription", new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_USERS_DELETE_NO_MODIFIABLE_DESCRIPTION"));
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> addUser(String populationId, String userDirectoryId, Map<String, String> untypedValues) throws InvalidModificationException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(populationId);
        UserDirectory userDirectory = userPopulation.getUserDirectory(userDirectoryId);
        if (userDirectory == null) {
            throw new InvalidModificationException("User directory with ID '" + userDirectoryId + "' in population '" + populationId + "' has not been found.");
        }
        if (!(userDirectory instanceof ModifiableUserDirectory)) {
            throw new InvalidModificationException("User directory is not modifiable!");
        }
        if (!this._canHandle(populationId)) {
            throw new AccessDeniedException("The user " + String.valueOf(this._getCurrentUser()) + " tried to add user without sufficient rights");
        }
        ModifiableUserDirectory modifiableUserDirectory = (ModifiableUserDirectory)userDirectory;
        String login = untypedValues.get("login");
        try {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info(String.format("User %s is adding a new user '%s'", this._getCurrentUser(), login));
            }
            modifiableUserDirectory.add(untypedValues, User.UserCreationOrigin.ADMIN);
            return this._userHelper.user2json(modifiableUserDirectory.getUserIdentity(login), true);
        }
        catch (InvalidModificationException e) {
            Map<String, List<I18nizableText>> fieldErrors = e.getFieldErrors();
            if (fieldErrors == null || fieldErrors.size() <= 0) {
                throw e;
            }
            result.put("errors", fieldErrors);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Ending user's edition");
            }
            return result;
        }
    }

    protected boolean _canHandle(String populationId) {
        UserIdentity currentUser = this._getCurrentUser();
        return this._rightManager.hasRight(currentUser, "Runtime_Rights_User_Handle", "/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW || this._rightManager.hasRight(currentUser, "Runtime_Rights_User_OwnPopulation_Handle", "/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW && currentUser.getPopulationId().equals(populationId);
    }

    @Callable(rights={""})
    public Map<String, Object> editUser(String populationId, Map<String, String> untypedValues) throws InvalidModificationException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String login = untypedValues.get("login");
        UserDirectory userDirectory = this._userManager.getUserDirectory(populationId, login);
        if (userDirectory == null) {
            throw new InvalidModificationException("User directory for user '" + login + "' with population '" + populationId + "' has not been found, maybe the user does not exists anymore.");
        }
        if (!(userDirectory instanceof ModifiableUserDirectory)) {
            throw new InvalidModificationException("Users are not modifiable!");
        }
        if (!this._canHandle(populationId)) {
            throw new AccessDeniedException("The user " + String.valueOf(this._getCurrentUser()) + " tried to edit user without sufficient rights");
        }
        ModifiableUserDirectory modifiableUserDirectory = (ModifiableUserDirectory)userDirectory;
        try {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info(String.format("User %s is updating information about user '%s'", this._getCurrentUser(), login));
            }
            modifiableUserDirectory.update(untypedValues);
            return this._userHelper.user2json(modifiableUserDirectory.getUserIdentity(login), true);
        }
        catch (InvalidModificationException e) {
            Map<String, List<I18nizableText>> fieldErrors = e.getFieldErrors();
            if (fieldErrors == null || fieldErrors.size() <= 0) {
                throw e;
            }
            result.put("errors", fieldErrors);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Ending user's edition");
            }
            return result;
        }
    }

    @Callable(rights={""})
    public Map<String, Object> deleteUsers(List<Map<String, String>> users) throws InvalidModificationException {
        ArrayList<Map<String, String>> deletedUsers = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> unauthorizedUsers = new ArrayList<Map<String, String>>();
        for (Map<String, String> user : users) {
            String login = user.get("login");
            String populationId = user.get("populationId");
            try {
                this._deleteUser(login, populationId);
                deletedUsers.add(user);
            }
            catch (AccessDeniedException e) {
                unauthorizedUsers.add(user);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Ending user's removal");
        }
        return Map.of("deletedUsers", deletedUsers, "unauthorizedUsers", unauthorizedUsers);
    }

    private void _deleteUser(String login, String populationId) throws InvalidModificationException {
        UserDirectory userDirectory = this._userManager.getUserDirectory(populationId, login);
        if (userDirectory == null) {
            throw new InvalidModificationException("User directory for user '" + login + "' with population '" + populationId + "' has not been found, maybe the user does not exists anymore.");
        }
        if (!(userDirectory instanceof ModifiableUserDirectory)) {
            throw new InvalidModificationException("User directory is not modifiable!");
        }
        if (populationId.equals("admin_population") && userDirectory.getStoredUsers().size() == 1) {
            throw new InvalidModificationException("You cannot delete the last user of the 'admin' population!");
        }
        if (!this._canHandle(populationId)) {
            throw new AccessDeniedException("The user " + String.valueOf(this._getCurrentUser()) + " tried to delete user without sufficient rights");
        }
        ModifiableUserDirectory modifiableUserDirectory = (ModifiableUserDirectory)userDirectory;
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(String.format("User %s is removing user '%s'", this._getCurrentUser(), login));
        }
        modifiableUserDirectory.remove(login);
    }

    @Callable(rights={"Runtime_Rights_User_Handle", "Runtime_Rights_User_OwnPopulation_Handle"})
    public Map<String, Object> getEditionModelForUSer(String login, String populationId) throws InvalidModificationException {
        UserDirectory userDirectory = this._userManager.getUserDirectory(populationId, login);
        if (userDirectory == null) {
            throw new InvalidModificationException("User directory for user '" + login + "' with population '" + populationId + "' has not been found, maybe the user does not exists anymore.");
        }
        if (!this._canHandle(populationId)) {
            throw new AccessDeniedException("The user " + String.valueOf(this._getCurrentUser()) + " tried to access user handle without sufficient rights");
        }
        return this._getEditionModel(userDirectory);
    }

    @Callable(rights={"Runtime_Rights_User_Handle", "Runtime_Rights_User_OwnPopulation_Handle"})
    public Map<String, Object> getEditionModelForDirectory(String populationId, String userDirectoryId) throws InvalidModificationException {
        UserDirectory userDirectory = this._userPopulationDAO.getUserPopulation(populationId).getUserDirectory(userDirectoryId);
        if (userDirectory == null) {
            throw new InvalidModificationException("User directory with ID '" + userDirectoryId + "' in population '" + populationId + "' has not been found.");
        }
        if (!this._canHandle(populationId)) {
            throw new AccessDeniedException("The user " + String.valueOf(this._getCurrentUser()) + " tried to handle user without sufficient rights");
        }
        return this._getEditionModel(userDirectory);
    }

    private Map<String, Object> _getEditionModel(UserDirectory userDirectory) throws InvalidModificationException {
        JdbcUserDirectory jdbcUserDirectory;
        if (!(userDirectory instanceof ModifiableUserDirectory)) {
            throw new InvalidModificationException("User directory is not modifiable!");
        }
        ModifiableUserDirectory modifiableUserDirectory = (ModifiableUserDirectory)userDirectory;
        View view = modifiableUserDirectory.getView();
        if (modifiableUserDirectory instanceof JdbcUserDirectory && (jdbcUserDirectory = (JdbcUserDirectory)modifiableUserDirectory).useStrongPassword()) {
            JdbcUserDirectory.StrongPasswordRequirements passwordRequirements = jdbcUserDirectory.getStrongPasswordRequirements();
            Map<String, I18nizableText> widgetParameters = passwordRequirements.getWidgetParameters();
            ViewElement modelViewItem = (ViewElement)view.getModelViewItem("password");
            modelViewItem.getDefinition().setWidgetParameters(widgetParameters);
        }
        return view.toJSON(DefinitionContext.newInstance().withEdition(true));
    }

    @Callable(rights={"Runtime_Rights_User_Handle"}, context="/admin")
    public Map<String, String> impersonate(String login, String populationId) throws AccessDeniedException {
        UserIdentity currentUser = this._getCurrentUser();
        if (StringUtils.isEmpty((CharSequence)login)) {
            throw new IllegalArgumentException("'login' parameter is null or empty");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        User user = this._userManager.getUser(populationId, login);
        if (user == null) {
            result.put("error", "unknown-user");
        } else {
            try {
                this._currentUserProvider.logout(null);
            }
            catch (ProcessingException e) {
                this.getLogger().error("An error occurred while logging out current user " + String.valueOf(currentUser));
            }
            Request request = ContextHelper.getRequest((Context)this._context);
            AuthenticateAction.setUserIdentityInSession(request, user.getIdentity(), new ImpersonateCredentialProvider(), true);
            result.put("login", login);
            result.put("populationId", populationId);
            result.put("name", user.getFullName());
            Map<String, Object> impersonateArgs = Map.of("login", login, "population", populationId);
            ForensicLogger.info("authentication.impersonation", impersonateArgs, currentUser);
        }
        return result;
    }

    protected UserIdentity _getCurrentUser() {
        if (this._currentUserProvider == null) {
            try {
                this._currentUserProvider = (CurrentUserProvider)this._smanager.lookup(CurrentUserProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new IllegalStateException(e);
            }
        }
        return this._currentUserProvider.getUser();
    }

    public static class ImpersonateCredentialProvider
    extends AbstractCredentialProvider
    implements BlockingCredentialProvider {
        @Override
        public boolean blockingGrantAnonymousRequest() {
            return false;
        }

        @Override
        public boolean blockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) {
            return true;
        }

        @Override
        public UserIdentity blockingGetUserIdentity(Redirector redirector) {
            return null;
        }

        @Override
        public void blockingUserNotAllowed(Redirector redirector) {
        }

        @Override
        public void blockingUserAllowed(UserIdentity userIdentity, Redirector redirector) {
        }

        @Override
        public boolean requiresNewWindow() {
            return false;
        }
    }
}

