/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.TransformerException;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.StoredUser;
import org.ametys.core.user.directory.UserDirectoryFactory;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.ConfigurationUtil;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UserHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = UserHelper.class.getName();
    private UserPopulationDAO _userPopulationDAO;
    private UserDirectoryFactory _userDirectoryFactory;
    private UserManager _userManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)smanager.lookup(UserPopulationDAO.ROLE);
        this._userDirectoryFactory = (UserDirectoryFactory)smanager.lookup(UserDirectoryFactory.ROLE);
    }

    public String getUserFullName(UserIdentity userIdentity) {
        User user = this._userManager.getUser(userIdentity);
        return user != null ? user.getFullName() : null;
    }

    public String getUserSortableName(UserIdentity userIdentity) {
        User user = this._userManager.getUser(userIdentity);
        return user != null ? user.getSortableName() : null;
    }

    private String _getStoredUserFullName(User user, StoredUser storedUser, boolean firstnameThenLastname) {
        if (user != null) {
            Stream<String> stream = firstnameThenLastname ? Stream.of(storedUser.getFirstName(), storedUser.getLastName()) : Stream.of(storedUser.getLastName(), storedUser.getFirstName());
            String sortableName = stream.filter(StringUtils::isNotEmpty).collect(Collectors.joining(" "));
            return (String)StringUtils.defaultIfEmpty((CharSequence)sortableName, (CharSequence)user.getIdentity().getLogin());
        }
        return null;
    }

    public List<Map<String, Object>> userIdentities2json(Collection<UserIdentity> users) {
        return users.stream().map(user -> this.user2json((UserIdentity)user)).collect(Collectors.toList());
    }

    public List<Map<String, Object>> users2json(Collection<User> users) {
        return this.users2json(users, false, false);
    }

    public List<Map<String, Object>> users2json(Collection<User> users, boolean full) {
        return this.users2json(users, full, false);
    }

    public List<Map<String, Object>> users2json(Collection<User> users, boolean full, boolean limitedToStoredUserData) {
        ArrayList<Map<String, Object>> userList = new ArrayList<Map<String, Object>>();
        LinkedHashSet<User> distinctUsers = new LinkedHashSet<User>(users);
        for (User user : distinctUsers) {
            userList.add(this.user2json(user, full, limitedToStoredUserData));
        }
        return userList;
    }

    public Map<String, Object> user2json(UserIdentity userIdentity) {
        return this.user2json(userIdentity, false, false);
    }

    public Map<String, Object> user2json(UserIdentity userIdentity, boolean full) {
        return this.user2json(userIdentity, full, false);
    }

    public Map<String, Object> user2json(UserIdentity userIdentity, boolean full, boolean limitedToStoredUserData) {
        User user = this._userManager.getUser(userIdentity);
        if (user != null) {
            return this.user2json(user, full, limitedToStoredUserData);
        }
        if (userIdentity != null) {
            return this._user2json(userIdentity, full);
        }
        return Collections.EMPTY_MAP;
    }

    private Map<String, Object> _user2json(UserIdentity userIdentity, boolean full) {
        UserPopulation up;
        HashMap<String, Object> userInfos = new HashMap<String, Object>();
        userInfos.put("login", userIdentity.getLogin());
        userInfos.put("populationId", userIdentity.getPopulationId());
        if (full && (up = this._userPopulationDAO.getUserPopulation(userIdentity.getPopulationId())) != null) {
            userInfos.put("populationLabel", up.getLabel());
        }
        return userInfos;
    }

    public Map<String, Object> user2json(User user) {
        return this._user2json(user, false, false);
    }

    public Map<String, Object> user2json(User user, boolean full) {
        return this.user2json(user, full, false);
    }

    public Map<String, Object> user2json(User user, boolean full, boolean limitedToStoredUserData) {
        return this._user2json(user, full, limitedToStoredUserData);
    }

    private Map<String, Object> _user2json(User user, boolean full, boolean limitedToStoredUserData) {
        if (user == null) {
            return null;
        }
        Map<String, Object> userInfos = this._user2json(user.getIdentity(), full);
        StoredUser storedUser = user.getStoredUser();
        userInfos.put("fullname", limitedToStoredUserData ? this._getStoredUserFullName(user, storedUser, true) : user.getFullName());
        userInfos.put("sortablename", limitedToStoredUserData ? this._getStoredUserFullName(user, storedUser, false) : user.getSortableName());
        if (full) {
            String udModelId = user.getUserDirectory() != null ? user.getUserDirectory().getUserDirectoryModelId() : "";
            userInfos.put("directory", this._userDirectoryFactory.hasExtension(udModelId) ? this._userDirectoryFactory.getExtension(udModelId).getLabel() : "");
            userInfos.put("lastname", limitedToStoredUserData ? storedUser.getLastName() : user.getLastName());
            userInfos.put("firstname", limitedToStoredUserData ? storedUser.getFirstName() : user.getFirstName());
            userInfos.put("email", limitedToStoredUserData ? storedUser.getEmail() : user.getEmail());
            userInfos.put("creationDate", limitedToStoredUserData ? storedUser.getCreationDate() : user.getCreationDate());
            userInfos.put("creationOrigin", (Object)(limitedToStoredUserData ? storedUser.getCreationOrigin() : user.getCreationOrigin()));
        }
        return userInfos;
    }

    public UserIdentity json2userIdentity(Map<String, ? extends Object> json) {
        return Optional.ofNullable(json).filter(u -> !u.isEmpty() && u.get("login") != null && u.get("populationId") != null).map(u -> new UserIdentity((String)u.get("login"), (String)u.get("populationId"))).orElse(null);
    }

    @Deprecated
    public User getUser(UserIdentity userIdentity) {
        return this._userManager.getUser(userIdentity);
    }

    @Deprecated
    public User getUserByEmail(String populationId, String email) {
        try {
            return this._userManager.getUserByEmail(populationId, email);
        }
        catch (NotUniqueUserException e) {
            this.getLogger().error("Cannot find user in population '" + populationId + "' by email '" + email + "' because 2 or more users matches", (Throwable)e);
            return null;
        }
    }

    public void saxUserIdentity(UserIdentity userIdentity, ContentHandler handler) throws SAXException {
        this.saxUserIdentity(userIdentity, handler, "user");
    }

    public void saxUserIdentity(UserIdentity userIdentity, ContentHandler handler, String tagName) throws SAXException {
        User user = this._userManager.getUser(userIdentity);
        if (user != null) {
            this.saxUser(user, handler, tagName);
        } else {
            this.getLogger().warn("Unable to sax unknown user with identity {}", (Object)userIdentity);
        }
    }

    public void saxUser(User user, ContentHandler handler) throws SAXException {
        this.saxUser(user, handler, "user");
    }

    public void saxUser(User user, ContentHandler handler, String tagName) throws SAXException {
        if (user != null) {
            AttributesImpl attr = new AttributesImpl();
            attr.addCDATAAttribute("login", user.getIdentity().getLogin());
            attr.addCDATAAttribute("population", user.getIdentity().getPopulationId());
            XMLUtils.startElement((ContentHandler)handler, (String)tagName, (Attributes)attr);
            XMLUtils.createElement((ContentHandler)handler, (String)"lastname", (String)user.getLastName());
            XMLUtils.createElement((ContentHandler)handler, (String)"firstname", (String)user.getFirstName());
            XMLUtils.createElement((ContentHandler)handler, (String)"email", (String)user.getEmail());
            XMLUtils.createElement((ContentHandler)handler, (String)"fullname", (String)user.getFullName());
            XMLUtils.createElement((ContentHandler)handler, (String)"sortablename", (String)user.getSortableName());
            this._userPopulationDAO.getUserPopulation(user.getIdentity().getPopulationId()).getLabel().toSAX(handler, "populationLabel");
            XMLUtils.endElement((ContentHandler)handler, (String)tagName);
        } else if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Unable to sax null user", (Throwable)new Exception());
        }
    }

    public UserIdentity xml2userIdentity(Configuration userConfiguration) throws ConfigurationException {
        Element userElement = ConfigurationUtil.toElement((Configuration)userConfiguration);
        try {
            return this.xml2userIdentity(userElement);
        }
        catch (TransformerException e) {
            throw new ConfigurationException("An error occurred while parsing the configuration of an I/O data", (Throwable)e);
        }
    }

    public UserIdentity xml2userIdentity(Node userNode) throws TransformerException {
        String login = Objects.requireNonNull(XPathAPI.eval((Node)userNode, (String)"@login").str());
        String population = Objects.requireNonNull(XPathAPI.eval((Node)userNode, (String)"@population").str());
        return new UserIdentity(login, population);
    }
}

