/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.user.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.plugins.core.user.UserManagementException;
import org.ametys.plugins.core.user.management.UserPasswordManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class UserPasswordAction
extends ServiceableAction {
    public static final String ERRORS_REQUEST_ATTRIBUTE_NAME = "errors";
    protected CurrentUserProvider _currentUserProvider;
    protected UserPasswordManager _userPasswordManager;
    protected UserManager _userManager;
    protected PopulationContextHelper _populationContextHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._populationContextHelper = (PopulationContextHelper)serviceManager.lookup(PopulationContextHelper.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        this._lazyloading();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap<String, String> results = new HashMap<String, String>();
        Map<Object, Object> errors = new HashMap<String, List>();
        UserIdentity user = null;
        try {
            user = this._getUser(request);
        }
        catch (UserManagementException e) {
            ArrayList<I18nizableText> tokenError = new ArrayList<I18nizableText>();
            tokenError.add(new I18nizableText(e.getStatus()));
            errors.put("global", tokenError);
        }
        boolean lostPassword = user == null && this._isLostPasswordStep(request);
        boolean requestReset = user == null && !lostPassword;
        boolean reinitPassword = user != null && this._isReinitPasswordStep(request);
        boolean submitPassword = user != null && !reinitPassword;
        boolean weakPassword = "true".equals(request.getParameter("weak-password"));
        try {
            if (lostPassword) {
                results.put("step", "lost-password");
            } else if (requestReset) {
                results.put("step", "reset-password");
                errors = this.requestPasswordReset(request);
                if (errors.isEmpty()) {
                    results.put("status", "success");
                }
            } else if (reinitPassword) {
                results.put("step", "password");
                results.put("userIdentity", UserIdentity.userIdentityToString(user));
                if (weakPassword) {
                    results.put("weak-password", "true");
                }
            } else if (submitPassword) {
                results.put("step", "user-update");
                results.put("userIdentity", UserIdentity.userIdentityToString(user));
                List<I18nizableText> changeUserPassword = this.changeUserPassword(user, request);
                if (changeUserPassword.isEmpty()) {
                    results.put("status", "success");
                } else {
                    errors.put("Password", changeUserPassword);
                }
            }
        }
        catch (UserManagementException e) {
            List globalErrors = errors.computeIfAbsent("global", str -> new ArrayList());
            globalErrors.add(new I18nizableText("plugin.core", "PLUGINS_CORE_PASSWORD_CHANGE_ERROR"));
            results.put("step", "error");
            this.getLogger().error("An error occurred resetting a user password.", (Throwable)e);
        }
        if (!errors.isEmpty()) {
            request.setAttribute(ERRORS_REQUEST_ATTRIBUTE_NAME, errors);
        }
        return results;
    }

    private void _lazyloading() throws ServiceException {
        if (this._userPasswordManager == null) {
            this._userPasswordManager = (UserPasswordManager)this.manager.lookup(UserPasswordManager.ROLE);
        }
    }

    private boolean _isReinitPasswordStep(Request request) {
        String password = request.getParameter("Password");
        String confirm = request.getParameter("ConfirmPassword");
        return StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{password, confirm});
    }

    private boolean _isLostPasswordStep(Request request) {
        String selectedPopulation = this._getSelectedPopulation(request);
        String userName = request.getParameter("Username");
        return StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{userName, selectedPopulation});
    }

    protected UserIdentity _getUser(Request request) throws UserManagementException {
        String token = request.getParameter("token");
        boolean tokenPresent = StringUtils.isNotEmpty((CharSequence)token);
        if (tokenPresent) {
            return this._userPasswordManager.checkPasswordChangeToken(token);
        }
        return null;
    }

    protected Map<String, List<I18nizableText>> requestPasswordReset(Request request) throws UserManagementException {
        HashMap<String, List<I18nizableText>> errors = new HashMap<String, List<I18nizableText>>();
        String selectedPopulation = this._getSelectedPopulation(request);
        String userName = request.getParameter("Username");
        try {
            this._userPasswordManager.resetUserPassword(request, userName, selectedPopulation);
        }
        catch (UserManagementException e) {
            switch (e.getStatus()) {
                case "POPULATION_UNKNOWN": 
                case "USER_UNKNOWN": 
                case "UNMODIFIABLE_USER_DIRECTORY": 
                case "NOT_UNIQUE_USER": 
                case "EMPTY_EMAIL": 
                case "MAIL_ERROR": {
                    ArrayList<I18nizableText> globalErrors = new ArrayList<I18nizableText>();
                    globalErrors.add(new I18nizableText(e.getStatus()));
                    errors.put("global", globalErrors);
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        return errors;
    }

    protected String _getSelectedPopulation(Request request) {
        String selectedPopulation = request.getParameter("UserPopulation");
        if (StringUtils.isEmpty((CharSequence)selectedPopulation)) {
            String contexts = request.getParameter("contexts");
            HashSet<String> populationsOnContext = new HashSet<String>();
            if (StringUtils.isNotEmpty((CharSequence)contexts)) {
                for (String context : StringUtils.split((String)contexts, (String)",")) {
                    populationsOnContext.addAll(this._populationContextHelper.getUserPopulationsOnContext(context, false));
                }
                if (populationsOnContext.size() == 1) {
                    return (String)populationsOnContext.stream().findFirst().get();
                }
            }
        }
        return selectedPopulation;
    }

    protected List<I18nizableText> changeUserPassword(UserIdentity userIdentity, Request request) throws UserManagementException {
        String password = request.getParameter("Password");
        String confirm = request.getParameter("ConfirmPassword");
        ArrayList<I18nizableText> passwordErrors = new ArrayList<I18nizableText>();
        if (StringUtils.isEmpty((CharSequence)password)) {
            passwordErrors.add(new I18nizableText("plugin.core", "PLUGINS_CORE_PASSWORD_CHANGE_ERROR_EMPTY_PASSWORD"));
        } else if (!Strings.CS.equals(password, confirm)) {
            passwordErrors.add(new I18nizableText("plugin.core", "PLUGINS_CORE_PASSWORD_CHANGE_ERROR_PASSWORD_CONFIRMATION_DOESNT_MATCH"));
        } else {
            passwordErrors = this._userPasswordManager.validatePassword(userIdentity, password);
        }
        if (!passwordErrors.isEmpty()) {
            return passwordErrors;
        }
        this._userPasswordManager.changeUserPassword(userIdentity, password);
        return passwordErrors;
    }
}

