/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.user.management;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.core.authentication.token.AuthenticationTokenManager;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.InvalidModificationException;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.ModifiableUserDirectory;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.core.user.UserManagementException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class UserPasswordManager
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = UserPasswordManager.class.getName();
    public static final String RESET_PASSWORD_URL = "plugins/core/reset-password.html";
    private static final int __CHANGE_PASSWORD_TOKEN_EXPIRATION_TIME = 300;
    private static final String __CHANGE_PASSWORD_TOKEN_TYPE = "change-password";
    private static final String __CHANGE_PASSWORD_TOKEN_CONTEXT = "change-password";
    private static final String __EVENT_ACCOUNT_PASSWORD_CHANGE = "account.password.change";
    private static final String __EVENT_ACCOUNT_PASSWORD_CHANGE_FAILED = "account.password.change.failed";
    private static final String __EVENT_ACCOUNT_PASSWORD_RESET = "account.password.reset";
    protected UserPopulationDAO _populationDAO;
    protected AuthenticationTokenManager _tokenManager;
    protected UserManager _userManager;
    protected I18nUtils _i18nUtils;
    protected UserLanguagesManager _userLanguagesManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._i18nUtils = (I18nUtils)((Object)manager.lookup(I18nUtils.ROLE));
        this._populationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._tokenManager = (AuthenticationTokenManager)manager.lookup(AuthenticationTokenManager.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._userLanguagesManager = (UserLanguagesManager)manager.lookup(UserLanguagesManager.ROLE);
    }

    public UserIdentity checkPasswordChangeToken(String token) throws UserManagementException {
        UserIdentity userIdentity = this._tokenManager.validateToken(token, "change-password");
        if (userIdentity == null) {
            throw new UserManagementException("TOKEN_UNKNOWN", "Provided token is unknown.");
        }
        return userIdentity;
    }

    public List<I18nizableText> validatePassword(UserIdentity userIdentity, String newPassword) throws UserManagementException {
        UserDirectory userDirectory = this._userManager.getUserDirectory(userIdentity.getPopulationId(), userIdentity.getLogin());
        if (userDirectory instanceof ModifiableUserDirectory) {
            ModifiableUserDirectory directory = (ModifiableUserDirectory)userDirectory;
            Map<String, List<I18nizableText>> errors = directory.validate(Map.of("login", userIdentity.getLogin(), "password", newPassword));
            if (errors.containsKey("password")) {
                return errors.get("password");
            }
            return List.of();
        }
        throw new UserManagementException("UNMODIFIABLE_USER_DIRECTORY", "User directory " + userDirectory.getId() + "is not modifiable");
    }

    public void changeUserPassword(UserIdentity userIdentity, String password) throws UserManagementException {
        String login = userIdentity.getLogin();
        String populationId = userIdentity.getPopulationId();
        UserDirectory userDirectory = this._userManager.getUserDirectory(populationId, login);
        if (userDirectory instanceof ModifiableUserDirectory) {
            ModifiableUserDirectory directory = (ModifiableUserDirectory)userDirectory;
            try {
                directory.update(Map.of("login", login, "password", password));
            }
            catch (InvalidModificationException e) {
                this._logPasswordChangeFailed(login, populationId, "INVALID_MODIFICATION");
                throw new UserManagementException("INVALID_MODIFICATION", "New password is not a valid password", e);
            }
        } else {
            this._logPasswordChangeFailed(login, populationId, "UNMODIFIABLE_USER_DIRECTORY");
            throw new UserManagementException("UNMODIFIABLE_USER_DIRECTORY", "User directory " + populationId + "is not modifiable");
        }
        List<AuthenticationTokenManager.Token> tokens = this._tokenManager.getTokens(userIdentity, "change-password");
        tokens.stream().forEach(t -> this._tokenManager.deleteTokenById(t.getId()));
        ForensicLogger.info(__EVENT_ACCOUNT_PASSWORD_CHANGE, Map.of("login", login, "population", populationId), userIdentity);
    }

    protected void _logPasswordChangeFailed(String login, String populationId, String errorCause) {
        Map<String, Object> eventArgs = Map.of("login", login, "population", populationId, "error", errorCause);
        ForensicLogger.warn(__EVENT_ACCOUNT_PASSWORD_CHANGE_FAILED, eventArgs, new UserIdentity(login, populationId));
    }

    public Optional<String> getChangePasswordURI(Request request, UserIdentity userIdentity, boolean weakPassword) {
        try {
            String token = this._generateChangePasswordToken(userIdentity);
            Object uri = this._getChangePasswordURI(request, userIdentity, token);
            if (weakPassword) {
                uri = (String)uri + "&weak-password=true";
            }
            ForensicLogger.info(__EVENT_ACCOUNT_PASSWORD_RESET, Map.of("user", this._userManager.getUser(userIdentity)), userIdentity);
            return Optional.of(uri);
        }
        catch (UserManagementException e) {
            if (!"UNMODIFIABLE_USER_DIRECTORY".equals(e.getStatus())) {
                this.getLogger().error("Failed to build reset password URI for user {}", (Object)userIdentity, (Object)e);
            }
            return Optional.empty();
        }
    }

    protected String _getChangePasswordURI(Request request, UserIdentity userIdentity, String token) throws UserManagementException {
        UserIdentity identity = userIdentity;
        String populationId = identity.getPopulationId();
        UserDirectory userDirectory = this._userManager.getUserDirectory(populationId, identity.getLogin());
        if (userDirectory instanceof ModifiableUserDirectory) {
            StringBuilder builder = new StringBuilder().append(request.getScheme()).append("://").append(request.getServerName());
            int serverPort = request.getServerPort();
            if (request.isSecure() && serverPort != 443 || !request.isSecure() && serverPort != 80) {
                builder.append(":").append(serverPort);
            }
            builder.append(request.getContextPath()).append(request.getAttribute("workspaceURI")).append("/").append(RESET_PASSWORD_URL).append("?token=").append(token);
            return builder.toString();
        }
        throw new UserManagementException("UNMODIFIABLE_USER_DIRECTORY", "User can not be edited " + String.valueOf(userIdentity));
    }

    protected String _generateChangePasswordToken(UserIdentity userIdentity) throws UserManagementException {
        try {
            String token = this._tokenManager.generateToken(userIdentity, 300L, true, null, Set.of("change-password"), "change-password", "Password reinitialiazation token");
            return token;
        }
        catch (RuntimeException e) {
            throw new UserManagementException("DATABASE_ERROR", "Database error while inserting a password change token for " + String.valueOf(userIdentity), e);
        }
    }

    public void resetUserPassword(Request request, String loginOrEmail, String populationId) throws UserManagementException {
        UserPopulation population = this._populationDAO.getUserPopulation(populationId);
        if (population == null) {
            throw new UserManagementException("POPULATION_UNKNOWN", "Unknown population with id '" + populationId + "'");
        }
        User user = this._userManager.getUser(population, loginOrEmail);
        if (user == null) {
            try {
                user = this._userManager.getUserByEmail(population, loginOrEmail);
                if (user == null) {
                    throw new UserManagementException("USER_UNKNOWN", "Unknown user with login or email " + loginOrEmail + " in population " + populationId);
                }
            }
            catch (NotUniqueUserException e) {
                throw new UserManagementException("NOT_UNIQUE_USER", "Many users match for email '" + loginOrEmail + "' and population '" + populationId + "'", e);
            }
        }
        if (!(user.getUserDirectory() instanceof ModifiableUserDirectory)) {
            throw new UserManagementException("UNMODIFIABLE_USER_DIRECTORY", "User directory is not modifiable");
        }
        if (StringUtils.isEmpty((CharSequence)user.getEmail())) {
            throw new UserManagementException("EMPTY_EMAIL", "Can't send reset password mail to user with no email");
        }
        String token = this._generateChangePasswordToken(user.getIdentity());
        this._sendPasswordResetMail(request, user, token);
        ForensicLogger.info(__EVENT_ACCOUNT_PASSWORD_RESET, Map.of("user", user), user.getIdentity());
    }

    protected void _sendPasswordResetMail(Request request, User user, String token) throws UserManagementException {
        String changePasswordURI = this._getChangePasswordURI(request, user.getIdentity(), token);
        try {
            String language = user.getLanguage();
            SendMailHelper.newMail().withSubject(this._getResetPasswordMailSubject(language)).withTextBody(this._getResetPasswordMailTextBody(user, changePasswordURI, language)).withHTMLBody(this._getResetPasswordMailHTMLBody(user, changePasswordURI, language)).withSender(this._getResetPasswordMailSender(request)).withRecipient(user.getEmail()).sendMail();
        }
        catch (MessagingException | IOException e) {
            throw new UserManagementException("MAIL_ERROR", "An error occured while trying to send reset password mail.", e);
        }
    }

    protected String _getResetPasswordMailSender(Request request) {
        return (String)Config.getInstance().getValue("smtp.mail.from");
    }

    protected String _getResetPasswordMailSubject(String language) {
        return this._i18nUtils.translate(new I18nizableText("plugin.core", "PLUGINS_CORE_RESET_PASSWORD_MAIL_SUBJECT"), language);
    }

    protected String _getResetPasswordMailTextBody(User user, String changePasswordURI, String language) {
        return this._i18nUtils.translate(new I18nizableText("plugin.core", "PLUGINS_CORE_RESET_PASSWORD_MAIL_TEXT_BODY", Map.of("fullName", new I18nizableText(user.getFullName()), "changePasswordURI", new I18nizableText(changePasswordURI))), language);
    }

    protected String _getResetPasswordMailHTMLBody(User user, String changePasswordURI, String language) throws IOException {
        return StandardMailBodyHelper.newHTMLBody().withTitle(this._getResetPasswordMailSubject(language)).addMessage(new I18nizableText("plugin.core", "PLUGINS_CORE_RESET_PASSWORD_MAIL_HTML_BODY", Map.of("fullName", new I18nizableText(user.getFullName()), "changePasswordURI", new I18nizableText(changePasswordURI)))).withLink(changePasswordURI, new I18nizableText("plugin.core", "PLUGINS_CORE_RESET_PASSWORD_MAIL_HTML_LINK")).withLanguage(language).build();
    }
}

