/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.user.management;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.core.impl.user.directory.JdbcUserDirectory;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UserPasswordScreenGenerator
extends AbstractGenerator
implements Serviceable {
    protected PopulationContextHelper _populationContextHelper;
    protected UserPopulationDAO _userPopulationDAO;
    protected UserManager _userManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._populationContextHelper = (PopulationContextHelper)manager.lookup(PopulationContextHelper.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        this.contentHandler.startDocument();
        AttributesImpl attrs = new AttributesImpl();
        String step = this.parameters.getParameter("step", "error");
        attrs.addCDATAAttribute("step", step);
        String contexts = request.getParameter("contexts");
        if (StringUtils.isNotBlank((CharSequence)contexts)) {
            attrs.addCDATAAttribute("contexts", contexts.toString());
        }
        String status = this.parameters.getParameter("status", "");
        attrs.addCDATAAttribute("status", status);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"UserPassword", (Attributes)attrs);
        if (!Strings.CS.equals(status, "success")) {
            if (Strings.CS.equals(step, "lost-password") || Strings.CS.equals(step, "reset-password")) {
                this.saxResetPasswordForm(request);
            } else if (Strings.CS.equalsAny((CharSequence)step, new CharSequence[]{"password"}) || Strings.CS.equals(step, "user-update")) {
                this.saxChangePasswordForm(request);
            }
            this.saxErrors(request);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"UserPassword");
        this.contentHandler.endDocument();
    }

    protected void saxChangePasswordForm(Request request) throws SAXException {
        JdbcUserDirectory jdbcUserDirectory;
        if (this.parameters.getParameterAsBoolean("weak-password", false)) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"WeakPassword");
        }
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"token", (String)request.getParameter("token"));
        UserIdentity identity = UserIdentity.stringToUserIdentity(this.parameters.getParameter("userIdentity", null));
        UserDirectory userDirectory = this._userManager.getUser(identity).getUserDirectory();
        if (userDirectory instanceof JdbcUserDirectory && (jdbcUserDirectory = (JdbcUserDirectory)userDirectory).useStrongPassword()) {
            jdbcUserDirectory.getStrongPasswordRequirements().toSAX(this.contentHandler, "PasswordRequirements");
        }
    }

    protected void saxErrors(Request request) throws SAXException {
        Map errors = (Map)request.getAttribute("errors");
        if (errors != null && !errors.isEmpty()) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"errors");
            List globalErrors = (List)errors.remove("global");
            if (globalErrors != null) {
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"global");
                for (I18nizableText error : globalErrors) {
                    AttributesImpl errorAttrs = new AttributesImpl();
                    if (!error.isI18n()) {
                        errorAttrs.addCDATAAttribute("type", error.getLabel());
                        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"error", (Attributes)errorAttrs);
                        continue;
                    }
                    error.toSAX(this.contentHandler, "error");
                }
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"global");
            }
            for (String field : errors.keySet()) {
                List fieldErrors = (List)errors.get(field);
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("name", field);
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"field", (Attributes)attrs);
                for (I18nizableText error : fieldErrors) {
                    error.toSAX(this.contentHandler, "error");
                }
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"field");
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"errors");
        }
    }

    protected void saxResetPasswordForm(Request request) throws SAXException {
        boolean isAmetysPublic;
        Set<UserPopulation> availablePopulations = this._getAvailablePopulations(request);
        String selectedPopulation = request.getParameter("UserPopulation");
        boolean bl = isAmetysPublic = Config.getInstance() != null ? (Boolean)Config.getInstance().getValue("runtime.ametys.public") : false;
        if (availablePopulations != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("public", isAmetysPublic ? "true" : "false");
            attrs.addCDATAAttribute("size", Integer.toString(availablePopulations.size()));
            if (selectedPopulation != null) {
                attrs.addCDATAAttribute("currentValue", selectedPopulation);
            }
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"UserPopulations", (Attributes)attrs);
            if (!isAmetysPublic) {
                for (UserPopulation up : availablePopulations) {
                    attrs = new AttributesImpl();
                    attrs.addCDATAAttribute("id", up.getId());
                    XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"UserPopulation", (Attributes)attrs);
                    up.getLabel().toSAX(this.contentHandler, "label");
                    XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"UserPopulation");
                }
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"UserPopulations");
        }
    }

    private Set<UserPopulation> _getAvailablePopulations(Request request) {
        String contexts = request.getParameter("contexts");
        if (StringUtils.isNotBlank((CharSequence)contexts)) {
            HashSet<String> populationIds = new HashSet<String>();
            for (String context : StringUtils.split((String)contexts, (String)",")) {
                populationIds.addAll(this._populationContextHelper.getUserPopulationsOnContext(context, false));
            }
            return populationIds.stream().map(this._userPopulationDAO::getUserPopulation).collect(Collectors.toSet());
        }
        return new HashSet<UserPopulation>(this._userPopulationDAO.getEnabledUserPopulations(true));
    }
}

