/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.userpref;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesExtensionPoint;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.View;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetUserPreferencesAction
extends ServiceableAction {
    protected UserPreferencesExtensionPoint _userPrefEP;
    protected UserPreferencesManager _userPrefManager;
    private CurrentUserProvider _currentUserProvider;

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        if (this._userPrefEP == null) {
            this._userPrefEP = (UserPreferencesExtensionPoint)this.manager.lookup(UserPreferencesExtensionPoint.ROLE);
            this._userPrefManager = (UserPreferencesManager)((Object)this.manager.lookup(UserPreferencesManager.ROLE));
            this._currentUserProvider = (CurrentUserProvider)this.manager.lookup(CurrentUserProvider.ROLE);
        }
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String storageContext = parameters.getParameter("prefContext", request.getParameter("prefContext"));
        boolean excludePrivate = parameters.getParameterAsBoolean("excludePrivate", false);
        Map<String, String> contextVars = this.getContextVars(request);
        UserIdentity user = this.getUser(parameters);
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("username", user.getLogin());
        jsonObject.put("userpopulation", user.getPopulationId());
        jsonObject.put("context", storageContext);
        jsonObject.put("preferences", this.userPrefs2JsonObject(contextVars, excludePrivate));
        request.setAttribute(JSonReader.OBJECT_TO_READ, jsonObject);
        return EMPTY_MAP;
    }

    protected Map<String, Object> userPrefs2JsonObject(Map<String, String> contextVars, boolean excludePrivate) throws ProcessingException, UserPreferencesException {
        View userPreferencesView = this._userPrefEP.getUserPreferencesView(excludePrivate, contextVars);
        DefinitionContext definitionContext = DefinitionContext.newInstance().withEdition(true);
        return userPreferencesView.toJSON(definitionContext);
    }

    protected UserIdentity getUser(Parameters parameters) {
        String login = parameters.getParameter("username", "");
        String populationId = parameters.getParameter("populationId", "");
        UserIdentity user = StringUtils.isEmpty((CharSequence)login) || StringUtils.isEmpty((CharSequence)populationId) ? this._currentUserProvider.getUser() : new UserIdentity(login, populationId);
        return user;
    }

    protected Map<String, String> getContextVars(Request request) {
        HashMap<String, String> contextVars = new HashMap<String, String>();
        contextVars.put("workspace", (String)request.getAttribute("workspaceName"));
        return contextVars;
    }
}

