/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.userpref;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreference;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesExtensionPoint;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.AvalonLoggerAdapter;
import org.ametys.core.util.cocoon.AbstractCurrentUserProviderServiceableAction;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.CategorizedElementDefinitionHelper;
import org.ametys.runtime.model.disableconditions.DefaultDisableConditionsEvaluator;
import org.ametys.runtime.model.disableconditions.DisableConditionsEvaluator;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.model.type.ModelItemType;
import org.ametys.runtime.parameter.ValidationResult;
import org.ametys.runtime.parameter.ValidationResults;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class SetUserPreferencesAction
extends AbstractCurrentUserProviderServiceableAction {
    protected UserPreferencesExtensionPoint _userPrefEP;
    protected UserPreferencesManager _userPrefManager;
    protected DisableConditionsEvaluator _disableConditionsEvaluator;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userPrefEP = (UserPreferencesExtensionPoint)this.manager.lookup(UserPreferencesExtensionPoint.ROLE);
        this._userPrefManager = (UserPreferencesManager)((Object)this.manager.lookup(UserPreferencesManager.ROLE));
        this._disableConditionsEvaluator = (DisableConditionsEvaluator)this.manager.lookup(DefaultDisableConditionsEvaluator.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Map parentContext = (Map)objectModel.get("parent-context");
        String storageContext = this.getStorageContext(request, parameters);
        UserIdentity user = this.getUser(request, parameters);
        String submit = request.getParameter("submit");
        Map<Object, Object> results = new HashMap();
        if ("true".equals(submit)) {
            Collection<String> preferenceIds = this.getPreferenceIds(request, parentContext);
            Map<String, String> contextVars = this.getContextVars(request);
            results = this.setUserPreferences(request, storageContext, contextVars, user, preferenceIds);
        }
        return results;
    }

    protected UserIdentity getUser(Request request, Parameters parameters) {
        String username = parameters.getParameter("username", "");
        String userPopulation = parameters.getParameter("userpopulation", "");
        UserIdentity user = StringUtils.isEmpty((CharSequence)username) || StringUtils.isEmpty((CharSequence)userPopulation) ? this._getCurrentUser() : new UserIdentity(username, userPopulation);
        return user;
    }

    protected String getStorageContext(Request request, Parameters parameters) {
        return parameters.getParameter("prefContext", request.getParameter("prefContext"));
    }

    protected Map<String, String> setUserPreferences(Request request, String storageContext, Map<String, String> contextVars, UserIdentity user) throws UserPreferencesException {
        return this.setUserPreferences(request, storageContext, contextVars, user, Collections.emptySet());
    }

    protected Map<String, String> setUserPreferences(Request request, String storageContext, Map<String, String> contextVars, UserIdentity user, Collection<String> preferenceIds) throws UserPreferencesException {
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("status", "error");
        Collection<UserPreference> userPreferences = this._userPrefEP.getUserPreferences(contextVars);
        Map<String, Object> typedValues = this._userPrefManager.getTypedUserPrefs(user, storageContext, contextVars);
        ValidationResults validationResults = this._preValidateRawValues(request, userPreferences, user, preferenceIds);
        typedValues.putAll(this._getTypedValues(request, userPreferences, user, preferenceIds));
        List<UserPreference> valuedUserPreferences = userPreferences.stream().filter(userPref -> typedValues.containsKey(userPref.getName())).toList();
        validationResults.addResults(CategorizedElementDefinitionHelper.validateValuesForWriting(typedValues, valuedUserPreferences, this._disableConditionsEvaluator, new AvalonLoggerAdapter(this.getLogger())));
        if (!validationResults.hasErrors()) {
            Map<String, String> valuesAsString = this._valuesToString(typedValues, userPreferences);
            this._userPrefManager.setUserPreferences(user, storageContext, contextVars, valuesAsString);
            results.put("status", "success");
        } else {
            request.setAttribute("user-prefs-errors", validationResults.getAllErrors());
        }
        return results;
    }

    protected ValidationResults _preValidateRawValues(Request request, Collection<UserPreference> userPreferences, UserIdentity user, Collection<String> preferenceIds) {
        ValidationResults results = new ValidationResults();
        for (UserPreference preference : userPreferences) {
            String confirmationValue;
            String name;
            String rawValue;
            if (!"password".equals(preference.getType().getId()) || !StringUtils.isNotBlank((CharSequence)(rawValue = request.getParameter(name = preference.getName()))) || rawValue.equals(confirmationValue = request.getParameter(name + "-confirmation"))) continue;
            ValidationResult result = new ValidationResult();
            result.addError(new I18nizableText("plugin.core", "PLUGINS_CORE_UI_USER_PREFERENCES_PWD_CONFIRMATION_DOESNT_MATCH"));
            results.addResult(name, result);
        }
        return results;
    }

    protected Map<String, Object> _getTypedValues(Request request, Collection<UserPreference> userPreferences, UserIdentity user, Collection<String> preferenceIds) {
        HashMap<String, Object> typedValues = new HashMap<String, Object>();
        for (UserPreference userPreference : userPreferences) {
            String name = userPreference.getName();
            ModelItemType type = userPreference.getType();
            if ("boolean".equals(type.getId()) && !preferenceIds.contains(name)) continue;
            Object rawValue = userPreference.isMultiple() ? Arrays.asList(request.getParameterValues(name)) : request.getParameter(name);
            Optional<Object> typedValue = Optional.ofNullable(type.fromJSONForClient(rawValue, DataContext.newInstance()));
            typedValue.ifPresent(val -> typedValues.put(name, val));
        }
        return typedValues;
    }

    protected Map<String, String> _valuesToString(Map<String, Object> typedValues, Collection<UserPreference> userPreferences) {
        HashMap<String, String> valuesAsString = new HashMap<String, String>();
        for (String name : typedValues.keySet()) {
            Object typedValue = typedValues.get(name);
            UserPreference userPreference = userPreferences.stream().filter(userPref -> name.equals(userPref.getName())).findFirst().orElse(null);
            if (userPreference != null) {
                String valueAsString;
                ModelItemType type = userPreference.getType();
                if (typedValue != null && typedValue.getClass().isArray()) {
                    List valueAsStrings = Arrays.stream((Object[])typedValue).map(((ElementType)type)::toString).collect(Collectors.toList());
                    valueAsString = StringUtils.join(valueAsStrings, (char)',');
                } else {
                    valueAsString = type.toString(typedValue);
                }
                valuesAsString.put(name, valueAsString);
                continue;
            }
            valuesAsString.put(name, typedValue.toString());
        }
        return valuesAsString;
    }

    protected Map<String, String> getContextVars(Request request) {
        HashMap<String, String> contextVars = new HashMap<String, String>();
        contextVars.put("workspace", (String)request.getAttribute("workspaceName"));
        return contextVars;
    }

    protected Collection<String> getPreferenceIds(Request request, Map<String, Object> parentContext) {
        return Collections.emptySet();
    }
}

