/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.userpref;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreference;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesExtensionPoint;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.XMLUtils;
import org.ametys.core.util.cocoon.AbstractCurrentUserProviderServiceableGenerator;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.ModelViewItem;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.type.DataContext;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UserPreferencesGenerator
extends AbstractCurrentUserProviderServiceableGenerator {
    protected UserPreferencesExtensionPoint _userPrefEP;
    protected UserPreferencesManager _userPrefManager;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userPrefEP = (UserPreferencesExtensionPoint)serviceManager.lookup(UserPreferencesExtensionPoint.ROLE);
        this._userPrefManager = (UserPreferencesManager)((Object)serviceManager.lookup(UserPreferencesManager.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String storageContext = this.parameters.getParameter("prefContext", request.getParameter("prefContext"));
        boolean excludePrivate = this.parameters.getParameterAsBoolean("excludePrivate", false);
        Map<String, String> contextVars = this.getContextVars(request);
        UserIdentity user = this.getUser();
        if (StringUtils.isBlank((CharSequence)storageContext)) {
            throw new ProcessingException("Preferences context can't be blank");
        }
        try {
            this.contentHandler.startDocument();
            if (user != null) {
                AttributesImpl atts = new AttributesImpl();
                atts.addCDATAAttribute("username", user.getLogin());
                atts.addCDATAAttribute("userpopulation", user.getPopulationId());
                atts.addCDATAAttribute("context", storageContext);
                org.apache.cocoon.xml.XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"UserPreferences", (Attributes)atts);
                this._saxPreferences(storageContext, contextVars, user, excludePrivate);
                org.apache.cocoon.xml.XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"UserPreferences");
            } else {
                org.apache.cocoon.xml.XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"UserPreferences");
            }
            this.contentHandler.endDocument();
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Cannot get user preferences.", (Throwable)e);
            throw new ProcessingException("Cannot get user preferences.", (Throwable)e);
        }
    }

    protected UserIdentity getUser() {
        String login = this.parameters.getParameter("username", "");
        String populationId = this.parameters.getParameter("populationId", "");
        UserIdentity user = StringUtils.isEmpty((CharSequence)login) || StringUtils.isEmpty((CharSequence)populationId) ? this._currentUserProvider.getUser() : new UserIdentity(login, populationId);
        return user;
    }

    protected Map<String, String> getContextVars(Request request) {
        return Collections.emptyMap();
    }

    protected void _saxPreferences(String storageContext, Map<String, String> contextVars, UserIdentity user, boolean excludePrivate) throws ProcessingException, SAXException, UserPreferencesException {
        View view = this._userPrefEP.getUserPreferencesView(excludePrivate, contextVars);
        Map<String, Object> prefValues = this._userPrefManager.getTypedUserPrefs(user, storageContext, contextVars);
        org.apache.cocoon.xml.XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"groups");
        DefinitionContext context = DefinitionContext.newInstance();
        for (ViewItem groupViewItem : view.getViewItems()) {
            org.apache.cocoon.xml.XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"group");
            groupViewItem.getLabel().toSAX(this.contentHandler, "label");
            org.apache.cocoon.xml.XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"preferences");
            ViewItemAccessor groupViewItemAccessor = (ViewItemAccessor)((Object)groupViewItem);
            for (ViewItem preferenceViewItem : groupViewItemAccessor.getViewItems()) {
                UserPreference preference = (UserPreference)((ModelViewItem)preferenceViewItem).getDefinition();
                this._saxPreference(preference, prefValues.get(preferenceViewItem.getName()), context, contextVars);
            }
            org.apache.cocoon.xml.XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"preferences");
            org.apache.cocoon.xml.XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"group");
        }
        org.apache.cocoon.xml.XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"groups");
    }

    protected void _saxPreference(UserPreference preference, Object value, DefinitionContext definitionContext, Map<String, String> contextVars) throws SAXException, ProcessingException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addCDATAAttribute("name", preference.getName());
        attributes.addCDATAAttribute("plugin", preference.getPluginName());
        attributes.addCDATAAttribute("path", preference.getPath());
        attributes.addCDATAAttribute("type", preference.getType().getId());
        attributes.addCDATAAttribute("multiple", String.valueOf(preference.isMultiple()));
        attributes.addCDATAAttribute("private", Boolean.toString(preference.isPrivate()));
        org.apache.cocoon.xml.XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"preference", (Attributes)attributes);
        XMLUtils.createI18nElementIfNotNull(this.contentHandler, "label", preference.getLabel());
        XMLUtils.createI18nElementIfNotNull(this.contentHandler, "description", preference.getDescription());
        preference.toSAX(this.contentHandler, definitionContext);
        Object valueToSAX = value != null ? value : preference.getDefaultValue();
        preference.getType().valueToSAX(this.contentHandler, "value", valueToSAX, DataContext.newInstance());
        org.apache.cocoon.xml.XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"preference");
    }
}

