/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.cocoon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public class SitemapConfigurationExtensionPoint
extends AbstractLogEnabled
implements ExtensionPoint<Configuration[]>,
Component {
    public static final String ROLE = SitemapConfigurationExtensionPoint.class.getName();
    private static final Collection<String> __COMPONENTS = new ArrayList<String>();
    private Map<String, Collection<Configuration>> _sitemapConfigurations = new HashMap<String, Collection<Configuration>>();
    private Map<String, Configuration[]> _extensions = new HashMap<String, Configuration[]>();

    @Override
    public void addExtension(String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException {
        Configuration[] configurations = configuration.getChildren();
        this._extensions.put(id, configurations);
        for (Configuration config : configurations) {
            String name = config.getName();
            String componentName = name + "s";
            if (!__COMPONENTS.contains(componentName)) {
                String errorMessage = "The feature '" + pluginName + "." + featureName + "' declares an invalid sitemap component : " + name;
                this.getLogger().error(errorMessage);
                throw new IllegalArgumentException(errorMessage);
            }
            Collection<Configuration> configs = this._sitemapConfigurations.get(componentName);
            if (configs == null) {
                configs = new ArrayList<Configuration>();
                this._sitemapConfigurations.put(componentName, configs);
            }
            configs.add(config);
        }
    }

    @Override
    public Configuration[] getExtension(String id) {
        return this._extensions.get(id);
    }

    @Override
    public Set<String> getExtensionsIds() {
        return this._extensions.keySet();
    }

    @Override
    public boolean hasExtension(String id) {
        return this._extensions.containsKey(id);
    }

    @Override
    public void initializeExtensions() throws Exception {
    }

    public Collection<Configuration> getConfigurations(String component) {
        if (!this._sitemapConfigurations.containsKey(component)) {
            return null;
        }
        return this._sitemapConfigurations.get(component);
    }

    static {
        __COMPONENTS.add("actions");
        __COMPONENTS.add("generators");
        __COMPONENTS.add("transformers");
        __COMPONENTS.add("serializers");
        __COMPONENTS.add("readers");
        __COMPONENTS.add("matchers");
        __COMPONENTS.add("selectors");
        __COMPONENTS.add("pipes");
    }
}

